/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.mysql.fluent.LocationBasedRecommendedActionSessionsOperationStatusClient;
import com.azure.resourcemanager.mysql.fluent.models.RecommendedActionSessionsOperationStatusInner;
import com.azure.resourcemanager.mysql.implementation.MySqlManagementClientImpl;
import reactor.core.publisher.Mono;

public final class LocationBasedRecommendedActionSessionsOperationStatusClientImpl
implements LocationBasedRecommendedActionSessionsOperationStatusClient {
    private final ClientLogger logger = new ClientLogger(LocationBasedRecommendedActionSessionsOperationStatusClientImpl.class);
    private final LocationBasedRecommendedActionSessionsOperationStatusService service;
    private final MySqlManagementClientImpl client;

    LocationBasedRecommendedActionSessionsOperationStatusClientImpl(MySqlManagementClientImpl client) {
        this.service = (LocationBasedRecommendedActionSessionsOperationStatusService)RestProxy.create(LocationBasedRecommendedActionSessionsOperationStatusService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecommendedActionSessionsOperationStatusInner>> getWithResponseAsync(String locationName, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        String apiVersion = "2018-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2018-06-01", this.client.getSubscriptionId(), locationName, operationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecommendedActionSessionsOperationStatusInner>> getWithResponseAsync(String locationName, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        String apiVersion = "2018-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2018-06-01", this.client.getSubscriptionId(), locationName, operationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RecommendedActionSessionsOperationStatusInner> getAsync(String locationName, String operationId) {
        return this.getWithResponseAsync(locationName, operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RecommendedActionSessionsOperationStatusInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecommendedActionSessionsOperationStatusInner get(String locationName, String operationId) {
        return (RecommendedActionSessionsOperationStatusInner)this.getAsync(locationName, operationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecommendedActionSessionsOperationStatusInner> getWithResponse(String locationName, String operationId, Context context) {
        return (Response)this.getWithResponseAsync(locationName, operationId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MySqlManagementClien")
    private static interface LocationBasedRecommendedActionSessionsOperationStatusService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/locations/{locationName}/recommendedActionSessionsAzureAsyncOperation/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecommendedActionSessionsOperationStatusInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="locationName") String var4, @PathParam(value="operationId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

