/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.db2i.sqlgenerator;

import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.ext.db2i.database.DB2iDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertSetGenerator;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.DatabaseObject;

public class InsertSetGeneratorDB2i
extends InsertSetGenerator {
    public boolean supports(InsertSetStatement stmt, Database db) {
        return db instanceof DB2iDatabase;
    }

    public int getPriority() {
        return new InsertSetGenerator().getPriority() + 1;
    }

    public Sql[] generateSql(InsertSetStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement.peek() == null) {
            return new UnparsedSql[0];
        }
        StringBuilder sql = new StringBuilder();
        this.generateHeader(sql, statement, database);
        ArrayList<Sql> result = new ArrayList<Sql>();
        int index = 0;
        for (InsertStatement sttmnt : statement.getStatements()) {
            this.getInsertGenerator(database).generateValues(sql, sttmnt, database);
            sql.append(",");
            if (++index <= statement.getBatchThreshold()) continue;
            result.add(this.generateCompleteStatement(statement, sql));
            index = 0;
            sql = new StringBuilder();
            this.generateHeader(sql, statement, database);
        }
        if (index > 0) {
            result.add(this.generateCompleteStatement(statement, sql));
        }
        return result.toArray(new Sql[0]);
    }

    private Sql generateCompleteStatement(InsertSetStatement statement, StringBuilder sql) {
        sql.deleteCharAt(sql.lastIndexOf(","));
        return new UnparsedSql(sql.toString(), new DatabaseObject[]{this.getAffectedTable(statement)});
    }
}

