/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.logging;

import com.amazon.athena.logging.AthenaFileAppender;
import java.time.Clock;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class AthenaLogger {
    private static final ConcurrentHashMap<AthenaFileAppender, AthenaFileAppender> loggingCaptures = new ConcurrentHashMap();
    private final String name;
    private final Logger logger;

    private AthenaLogger(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
    }

    public static AthenaLogger of(Class<?> cls) {
        return new AthenaLogger(cls.getName(), LoggerFactory.getLogger(cls));
    }

    public static AthenaFileAppender createAppender() {
        return AthenaLogger.createAppender(Clock.systemUTC(), new AthenaFileAppender.Fs());
    }

    static AthenaFileAppender createAppender(Clock clock, AthenaFileAppender.Fs fsOperations) {
        AthenaFileAppender appender = new AthenaFileAppender(clock, fsOperations);
        loggingCaptures.put(appender, appender);
        return appender;
    }

    static void appenderStopped(AthenaFileAppender appender) {
        loggingCaptures.remove(appender);
    }

    private static void append(AthenaLogger logger, Level level, String message, Object[] args, Throwable cause) {
        for (AthenaFileAppender appender : loggingCaptures.keySet()) {
            appender.append(logger.name(), level, message, args, cause);
        }
    }

    public Logger wrappedLogger() {
        return this.logger;
    }

    public void trace(String message, Object ... args) {
        this.wrappedLogger().trace(message, args);
        AthenaLogger.append(this, Level.TRACE, message, args, null);
    }

    public void trace(String message, Throwable cause) {
        this.logger.trace(message, cause);
        AthenaLogger.append(this, Level.TRACE, message, null, cause);
    }

    public void debug(String message, Object ... args) {
        this.logger.debug(message, args);
        AthenaLogger.append(this, Level.DEBUG, message, args, null);
    }

    public void debug(String message, Throwable cause) {
        this.logger.debug(message, cause);
        AthenaLogger.append(this, Level.DEBUG, message, null, cause);
    }

    public void info(String message, Object ... args) {
        this.logger.info(message, args);
        AthenaLogger.append(this, Level.INFO, message, args, null);
    }

    public void info(String message, Throwable cause) {
        this.logger.info(message, cause);
        AthenaLogger.append(this, Level.INFO, message, null, cause);
    }

    public void warn(String message, Object ... args) {
        this.logger.warn(message, args);
        AthenaLogger.append(this, Level.WARN, message, args, null);
    }

    public void warn(String message, Throwable cause) {
        this.logger.warn(message, cause);
        AthenaLogger.append(this, Level.WARN, message, null, cause);
    }

    public void error(String message, Object ... args) {
        this.logger.error(message, args);
        AthenaLogger.append(this, Level.ERROR, message, args, null);
    }

    public void error(String message, Throwable cause) {
        this.logger.error(message, cause);
        AthenaLogger.append(this, Level.ERROR, message, null, cause);
    }

    @Generated
    public String name() {
        return this.name;
    }
}

