/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class TimestampCalculationFunction
extends JdbcFunction {
    private static final Map<String, String> INTERVAL_CONVERSIONS = new HashMap<String, String>(){
        {
            this.put("SQL_TSI_FRAC_SECOND", "millisecond");
            this.put("SQL_TSI_SECOND", "second");
            this.put("SQL_TSI_MINUTE", "minute");
            this.put("SQL_TSI_HOUR", "hour");
            this.put("SQL_TSI_DAY", "day");
            this.put("SQL_TSI_WEEK", "week");
            this.put("SQL_TSI_MONTH", "month");
            this.put("SQL_TSI_QUARTER", "quarter");
            this.put("SQL_TSI_YEAR", "year");
        }
    };

    TimestampCalculationFunction(String jdbcName, String athenaName) {
        super(jdbcName, athenaName, JdbcFunction.FunctionCategory.TIME_AND_DATE, 3, 3);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        Optional<Token> intervalExpr = this.findFirstExpression(args.get(0));
        Optional<String> interval = intervalExpr.map(t -> INTERVAL_CONVERSIONS.get(t.value().toUpperCase()));
        if (interval.isPresent()) {
            LinkedList intervalArg = new LinkedList(args.get(0));
            intervalArg.replaceAll(t -> t == intervalExpr.get() ? Token.sql(String.format("'%s'", interval.get())) : t);
            List<Token> secondArg = this.ensureHasWhitespacePrefix(args.get(1));
            return Arrays.asList(intervalArg, secondArg, args.get(2));
        }
        String unsupportedType = intervalExpr.map(Token::value).orElse("");
        String message = String.format("Unsupported interval for the %s function, got \"%s\"", this.jdbcName, unsupportedType);
        throw new FunctionExpressionException(message);
    }
}

