/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support;

import com.amazon.athena.jdbc.support.UncheckedSQLException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.utils.Pair;

public abstract class PaginatingIteratorBase<ElementType>
implements Iterator<ElementType> {
    private final Duration requestTimeout;
    protected List<ElementType> currentPage;
    protected int currentIndex;
    private Optional<String> nextToken;
    protected boolean exhausted;

    public PaginatingIteratorBase(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.currentPage = null;
        this.currentIndex = -1;
        this.nextToken = Optional.empty();
        this.exhausted = false;
    }

    protected abstract CompletableFuture<Pair<List<ElementType>, Optional<String>>> loadNextPage(Optional<String> var1);

    protected void loadNextPage() {
        CompletableFuture<Pair<List<ElementType>, Optional<String>>> pendingResponse = this.loadNextPage(this.nextToken);
        try {
            Pair<List<ElementType>, Optional<String>> response = pendingResponse.get(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
            this.nextToken = (Optional)response.right();
            this.currentPage = (List)response.left();
            this.currentIndex = -1;
            boolean bl = this.exhausted = !this.nextToken.isPresent();
            if (this.currentPage.isEmpty() && !this.exhausted) {
                this.loadNextPage();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedSQLException(new SQLException(e));
        }
        catch (TimeoutException e) {
            throw new UncheckedSQLException(new SQLTimeoutException(e));
        }
        catch (ExecutionException e) {
            SQLException se;
            if (e.getCause() instanceof SQLException) {
                se = (SQLException)e.getCause();
            } else {
                se = new SQLException(e.getCause());
                se.addSuppressed(e);
            }
            throw new UncheckedSQLException(se);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentPage == null || !this.exhausted && this.currentIndex + 1 >= this.currentPage.size()) {
            this.loadNextPage();
        }
        return this.currentPage != null && (!this.exhausted || this.currentIndex + 1 < this.currentPage.size());
    }

    @Override
    public ElementType next() {
        if (this.hasNext()) {
            ++this.currentIndex;
            return this.currentPage.get(this.currentIndex);
        }
        throw new NoSuchElementException();
    }
}

