/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public class ConnectionParameter<ValueType> {
    private final String name;
    private final List<String> allNames;
    private final Set<String> deprecatedAliases;
    private final ValueType defaultValue;
    private final boolean isSecret;
    private final Function<String, ValueType> valueConverter;

    public ConnectionParameter(String name) {
        this(name, Collections.emptySet(), Collections.emptySet());
    }

    public ConnectionParameter(String name, Set<String> aliases, Set<String> deprecatedAliases) {
        this(name, aliases, deprecatedAliases, null, false, null);
    }

    private ConnectionParameter(@NonNull String name, Set<String> aliases, Set<String> deprecatedAliases, ValueType defaultValue, Boolean isSecret, Function<String, ValueType> valueConverter) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.deprecatedAliases = deprecatedAliases;
        this.defaultValue = defaultValue;
        this.isSecret = isSecret != null ? isSecret : false;
        this.valueConverter = valueConverter;
        this.allNames = new ArrayList<String>();
        this.allNames.add(name);
        this.allNames.addAll(aliases);
        this.allNames.addAll(deprecatedAliases);
    }

    public String name() {
        return this.name;
    }

    public Collection<String> allNames() {
        return this.allNames;
    }

    public boolean isDeprecated(String parameterName) {
        return this.isDeprecated(parameterName, true);
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean isDeprecated(String parameterName, boolean caseSensitive) {
        if (caseSensitive) {
            return this.deprecatedAliases.contains(parameterName);
        }
        for (String deprecatedAlias : this.deprecatedAliases) {
            if (!deprecatedAlias.equalsIgnoreCase(parameterName)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> findPreferredKey(Map<String, String> parameters) {
        for (String name : this.allNames) {
            for (String key : parameters.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                return Optional.of(key);
            }
        }
        return Optional.empty();
    }

    public Optional<ValueType> findValue(Map<ConnectionParameter<?>, String> parameters) {
        String rawValue = parameters.get(this);
        if (rawValue == null) {
            return Optional.ofNullable(this.defaultValue);
        }
        if (this.valueConverter != null) {
            return Optional.ofNullable(this.valueConverter.apply(rawValue));
        }
        return Optional.ofNullable(rawValue);
    }

    @Generated
    public static <ValueType> ConnectionParameterBuilder<ValueType> builder() {
        return new ConnectionParameterBuilder();
    }

    @Generated
    public static class ConnectionParameterBuilder<ValueType> {
        @Generated
        private String name;
        @Generated
        private ArrayList<String> aliases;
        @Generated
        private ArrayList<String> deprecatedAliases;
        @Generated
        private ValueType defaultValue;
        @Generated
        private Boolean isSecret;
        @Generated
        private Function<String, ValueType> valueConverter;

        @Generated
        ConnectionParameterBuilder() {
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> alias(String alias) {
            if (this.aliases == null) {
                this.aliases = new ArrayList();
            }
            this.aliases.add(alias);
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> aliases(Collection<? extends String> aliases) {
            if (aliases == null) {
                throw new NullPointerException("aliases cannot be null");
            }
            if (this.aliases == null) {
                this.aliases = new ArrayList();
            }
            this.aliases.addAll(aliases);
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> clearAliases() {
            if (this.aliases != null) {
                this.aliases.clear();
            }
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> deprecatedAlias(String deprecatedAlias) {
            if (this.deprecatedAliases == null) {
                this.deprecatedAliases = new ArrayList();
            }
            this.deprecatedAliases.add(deprecatedAlias);
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> deprecatedAliases(Collection<? extends String> deprecatedAliases) {
            if (deprecatedAliases == null) {
                throw new NullPointerException("deprecatedAliases cannot be null");
            }
            if (this.deprecatedAliases == null) {
                this.deprecatedAliases = new ArrayList();
            }
            this.deprecatedAliases.addAll(deprecatedAliases);
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> clearDeprecatedAliases() {
            if (this.deprecatedAliases != null) {
                this.deprecatedAliases.clear();
            }
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> defaultValue(ValueType defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> isSecret(Boolean isSecret) {
            this.isSecret = isSecret;
            return this;
        }

        @Generated
        public ConnectionParameterBuilder<ValueType> valueConverter(Function<String, ValueType> valueConverter) {
            this.valueConverter = valueConverter;
            return this;
        }

        @Generated
        public ConnectionParameter<ValueType> build() {
            Set<Object> deprecatedAliases;
            Set<Object> aliases;
            switch (this.aliases == null ? 0 : this.aliases.size()) {
                case 0: {
                    aliases = Collections.emptySet();
                    break;
                }
                case 1: {
                    aliases = Collections.singleton(this.aliases.get(0));
                    break;
                }
                default: {
                    aliases = new LinkedHashSet(this.aliases.size() < 0x40000000 ? 1 + this.aliases.size() + (this.aliases.size() - 3) / 3 : Integer.MAX_VALUE);
                    aliases.addAll(this.aliases);
                    aliases = Collections.unmodifiableSet(aliases);
                }
            }
            switch (this.deprecatedAliases == null ? 0 : this.deprecatedAliases.size()) {
                case 0: {
                    deprecatedAliases = Collections.emptySet();
                    break;
                }
                case 1: {
                    deprecatedAliases = Collections.singleton(this.deprecatedAliases.get(0));
                    break;
                }
                default: {
                    deprecatedAliases = new LinkedHashSet(this.deprecatedAliases.size() < 0x40000000 ? 1 + this.deprecatedAliases.size() + (this.deprecatedAliases.size() - 3) / 3 : Integer.MAX_VALUE);
                    deprecatedAliases.addAll(this.deprecatedAliases);
                    deprecatedAliases = Collections.unmodifiableSet(deprecatedAliases);
                }
            }
            return new ConnectionParameter(this.name, aliases, deprecatedAliases, this.defaultValue, this.isSecret, this.valueConverter);
        }

        @Generated
        public String toString() {
            return "ConnectionParameter.ConnectionParameterBuilder(name=" + this.name + ", aliases=" + this.aliases + ", deprecatedAliases=" + this.deprecatedAliases + ", defaultValue=" + this.defaultValue + ", isSecret=" + this.isSecret + ", valueConverter=" + this.valueConverter + ")";
        }
    }
}

