/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.utils;

import com.amazon.athena.jdbc.support.DriverVersion;
import com.amazon.athena.jdbc.support.EndpointHelper;
import java.net.URI;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.AthenaClientBuilder;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClientBuilder;
import software.amazon.awssdk.services.ssooidc.SsoOidcClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.Credentials;

public class JwtTrustedIdentityProviderUtils {
    private final Optional<String> host;
    private final URI stsEndpoint;
    private final Optional<String> athenaEndpoint;
    private final Region region;
    private final ProxyConfiguration proxyConfiguration;
    private final URI ssoOidcEndpoint;
    private final URI ssoAdminEndpoint;

    public JwtTrustedIdentityProviderUtils(Region region, URI stsEndpoint, ProxyConfiguration proxyConfiguration, Optional<String> host, Optional<String> athenaEndpoint, URI ssoOidcEndpoint, URI ssoAdminEndpoint) {
        this.region = region;
        this.host = host;
        this.stsEndpoint = stsEndpoint;
        this.athenaEndpoint = athenaEndpoint;
        this.proxyConfiguration = proxyConfiguration;
        this.ssoOidcEndpoint = ssoOidcEndpoint;
        this.ssoAdminEndpoint = ssoAdminEndpoint;
    }

    public SsoAdminClient createSsoAdminClient(Credentials stsCredentials) {
        SsoAdminClientBuilder ssoAdminClientBuilder = SsoAdminClient.builder();
        ssoAdminClientBuilder.region(this.region);
        Optional.ofNullable(this.ssoAdminEndpoint).ifPresent(arg_0 -> ((SsoAdminClientBuilder)ssoAdminClientBuilder).endpointOverride(arg_0));
        if (this.proxyConfiguration != null) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration(this.proxyConfiguration);
            ssoAdminClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        return (SsoAdminClient)((SsoAdminClientBuilder)ssoAdminClientBuilder.credentialsProvider((AwsCredentialsProvider)this.getSessionCredentialProvider(stsCredentials))).build();
    }

    public SsoOidcClient createSsoOidcClient(Credentials stsCredentials) {
        SsoOidcClientBuilder ssoOidcClientBuilder = SsoOidcClient.builder();
        ssoOidcClientBuilder.region(this.region);
        Optional.ofNullable(this.ssoOidcEndpoint).ifPresent(arg_0 -> ((SsoOidcClientBuilder)ssoOidcClientBuilder).endpointOverride(arg_0));
        if (this.proxyConfiguration != null) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration(this.proxyConfiguration);
            ssoOidcClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        return (SsoOidcClient)((SsoOidcClientBuilder)ssoOidcClientBuilder.credentialsProvider((AwsCredentialsProvider)this.getSessionCredentialProvider(stsCredentials))).build();
    }

    public AthenaClient createAthenaClient(Credentials stsCredentials) {
        AthenaClientBuilder athenaClientBuilder = AthenaClient.builder();
        athenaClientBuilder.region(this.region);
        this.getAthenaEndpoint().ifPresent(arg_0 -> ((AthenaClientBuilder)athenaClientBuilder).endpointOverride(arg_0));
        ClientOverrideConfiguration.Builder clientOverrideConfigurationBuilder = ClientOverrideConfiguration.builder();
        clientOverrideConfigurationBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)this.getUserAgentString()).build();
        athenaClientBuilder.overrideConfiguration((ClientOverrideConfiguration)clientOverrideConfigurationBuilder.build());
        if (this.proxyConfiguration != null) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration(this.proxyConfiguration);
            athenaClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        athenaClientBuilder.credentialsProvider((AwsCredentialsProvider)this.getSessionCredentialProvider(stsCredentials));
        return (AthenaClient)athenaClientBuilder.build();
    }

    public StsClient createStsClient(Credentials credentials) {
        StsClientBuilder stsClientBuilder = StsClient.builder();
        stsClientBuilder.region(this.region);
        Optional.ofNullable(this.stsEndpoint).ifPresent(arg_0 -> ((StsClientBuilder)stsClientBuilder).endpointOverride(arg_0));
        if (this.proxyConfiguration != null) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration(this.proxyConfiguration);
            stsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        stsClientBuilder.credentialsProvider((AwsCredentialsProvider)this.getSessionCredentialProvider(credentials));
        return (StsClient)stsClientBuilder.build();
    }

    public StsClient createAnonymousStsClient() {
        StsClientBuilder stsClientBuilder = StsClient.builder();
        stsClientBuilder.region(this.region);
        Optional.ofNullable(this.stsEndpoint).ifPresent(arg_0 -> ((StsClientBuilder)stsClientBuilder).endpointOverride(arg_0));
        if (this.proxyConfiguration != null) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration(this.proxyConfiguration);
            stsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        stsClientBuilder.credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create());
        return (StsClient)stsClientBuilder.build();
    }

    private StaticCredentialsProvider getSessionCredentialProvider(Credentials stsCredentials) {
        AwsSessionCredentials credentials = AwsSessionCredentials.builder().accessKeyId(stsCredentials.accessKeyId()).secretAccessKey(stsCredentials.secretAccessKey()).sessionToken(stsCredentials.sessionToken()).expirationTime(stsCredentials.expiration()).build();
        return StaticCredentialsProvider.create((AwsCredentials)credentials);
    }

    private Optional<URI> getAthenaEndpoint() {
        if (this.host.isPresent() && this.athenaEndpoint.isPresent()) {
            throw new IllegalArgumentException("The Athena endpoint cannot be specified both in the host part of the connection string and as an endpoint parameter");
        }
        if (this.host.isPresent()) {
            return this.host.map(h -> EndpointHelper.constructEndpointUri(h, "Athena"));
        }
        return this.athenaEndpoint.map(e -> EndpointHelper.constructEndpointUri(e, "Athena"));
    }

    private String getUserAgentString() {
        StringBuilder userAgent = new StringBuilder("AthenaJDBC/").append(DriverVersion.instance().fullVersion());
        userAgent.append("(AthenaTIPConvenience: true), ");
        return userAgent.toString();
    }
}

