/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.http;

import com.amazon.athena.jdbc.authentication.http.InvalidHttpRequestHandler;
import com.amazon.athena.jdbc.authentication.http.ValidHttpRequestHandler;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class RequestHandler
implements HttpRequestHandler {
    private static final AthenaLogger logger = AthenaLogger.of(RequestHandler.class);
    public static final String ATHENA_PATH = "/athena";
    private static final String SUPPORTED_METHOD = "POST";
    private final Function<List<NameValuePair>, List<NameValuePair>> requestProcessLogic;
    private final HttpRequestHandler invalidRequestHandler;
    private final HttpRequestHandler validRequestHandler;
    private List<NameValuePair> result;

    public RequestHandler(Function<List<NameValuePair>, List<NameValuePair>> requestProcessLogic) {
        this.requestProcessLogic = requestProcessLogic;
        this.invalidRequestHandler = new InvalidHttpRequestHandler();
        this.validRequestHandler = new ValidHttpRequestHandler();
    }

    private void logHeaders(HttpRequest request) {
        Header[] headers;
        for (Header h : headers = request.getAllHeaders()) {
            logger.trace("Received header {} with value {}", h.getName(), h.getValue());
        }
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        this.logHeaders(request);
        if (this.isRequestValid(request)) {
            this.result = this.requestProcessLogic.apply(URLEncodedUtils.parse((HttpEntity)((BasicHttpEntityEnclosingRequest)request).getEntity()));
            this.validRequestHandler.handle(request, response, context);
        } else {
            this.invalidRequestHandler.handle(request, response, context);
        }
    }

    private boolean isRequestValid(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        logger.info("Validating request URI {} and method {}", requestLine.getUri(), requestLine.getMethod());
        return requestLine.getMethod().equalsIgnoreCase(SUPPORTED_METHOD) && requestLine.getUri().startsWith(ATHENA_PATH);
    }

    public List<NameValuePair> getResult() {
        return this.result;
    }
}

