/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone;

import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataZoneCredentialsProviderFactory {
    public static final ConnectionParameter<String> DATAZONE_DOMAIN_ID_PARAMETER = ConnectionParameter.builder().name("DataZoneDomainId").build();
    public static final ConnectionParameter<String> DATAZONE_ENVIRONMENT_ID_PARAMETER = ConnectionParameter.builder().name("DataZoneEnvironmentId").build();
    public static final ConnectionParameter<String> DATAZONE_DOMAIN_REGION_PARAMETER = ConnectionParameter.builder().name("DataZoneDomainRegion").build();
    public static final ConnectionParameter<String> DATAZONE_ENDPOINT_OVERRIDE_PARAMETER = ConnectionParameter.builder().name("DataZoneEndpointOverride").build();

    protected void validateParameters(Map<ConnectionParameter<?>, String> inputParameters, List<ConnectionParameter<?>> requiredParameters, String credentialsProviderName) {
        String errorMessage = requiredParameters.stream().filter(parameter -> !parameter.findValue(inputParameters).isPresent()).map(missingParameter -> String.format("The %s parameter must be specified when using the %s credentials provider", missingParameter.name(), credentialsProviderName)).collect(Collectors.joining("; "));
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

