/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.IdpCredentialsProvider;
import com.amazon.athena.jdbc.authentication.SamlCredentialsProvider;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;

public class PingCredentialsProvider
extends SamlCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(PingCredentialsProvider.class);
    private static final String URI_TEMPLATE = "https://%s:%s/idp/startSSO.ping?PartnerSpId=%s";
    private static final Pattern INPUT_TAG_PATTERN = Pattern.compile("<input(.+?)/>", 32);
    private static final Pattern NAME_PATTERN = Pattern.compile("name=\"([^\"]+)\"");
    private static final Pattern VALUE_PATTERN = Pattern.compile("value=\"([^\"]+)\"");
    private static final Pattern SAML_ASSERTION_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private final String username;
    private final String password;
    private final String hostName;
    private final Integer portNumber;
    private final String partnerSpId;
    private final Supplier<CloseableHttpClient> httpClientFactory;

    private PingCredentialsProvider(String username, String password, String hostName, Integer portNumber, String partnerSpId, String preferredRole, Integer roleSessionDuration, Region region, Supplier<CloseableHttpClient> httpClientFactory, AssumeRoleWithSamlRequest.Builder assumeRoleRequestFactory, StsClientBuilder stsClientFactory, AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleRequestFactory, LakeFormationClientBuilder lakeFormationClientFactory, boolean lakeFormationEnabled, Map<ConnectionParameter<?>, String> parameters) {
        super(assumeRoleRequestFactory, assumeDecoratedRoleRequestFactory, stsClientFactory, lakeFormationClientFactory, null, null, preferredRole, roleSessionDuration, region, lakeFormationEnabled, parameters);
        this.username = username;
        this.password = password;
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.partnerSpId = partnerSpId;
        this.httpClientFactory = httpClientFactory == null ? () -> IdpCredentialsProvider.createHttpClient(parameters) : httpClientFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String getSamlAssertion() {
        URI uri = this.constructPingEndpoint();
        logger.info("Making a request to get SAML assertion from the Ping URI: {}", uri);
        HttpGet get = new HttpGet(uri);
        List<NameValuePair> nameValuePairs = this.fetchNameValuePairs(get);
        HttpPost request = this.createSamlRequest(nameValuePairs);
        return this.fetchSamlAssertion(request);
    }

    private URI constructPingEndpoint() {
        try {
            return new URI(String.format(URI_TEMPLATE, this.hostName, this.portNumber, URLEncoder.encode(this.partnerSpId, "UTF-8")));
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Could not construct a valid Ping endpoint URL from the provided host (\"%s\"), port (\"%s\"), and partner SpId (\"%s\")", this.hostName, this.portNumber, this.partnerSpId), e);
        }
    }

    /*
     * Exception decompiling
     */
    private List<NameValuePair> fetchNameValuePairs(HttpGet request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpPost createSamlRequest(List<NameValuePair> parameters) {
        URI uri = this.constructPingEndpoint();
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8));
        return post;
    }

    /*
     * Exception decompiling
     */
    private String fetchSamlAssertion(HttpPost request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateHttpResponse(CloseableHttpResponse response) {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AuthenticationException(String.format("Unexpected error from Ping (HTTP response status code %s)", response.getStatusLine().getStatusCode()));
        }
    }

    private String extractResponseBody(CloseableHttpResponse response) {
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new AuthenticationException("An error occurred while processing the response from Ping", e);
        }
    }

    private String extractSamlAssertion(String responseString) {
        Matcher samlAssertionMatcher = SAML_ASSERTION_PATTERN.matcher(responseString);
        if (samlAssertionMatcher.find()) {
            return samlAssertionMatcher.group(1);
        }
        throw new AuthenticationException("Unable to extract the SAMLResponse field from the response body");
    }

    private List<NameValuePair> extractNameValuePairs(String body) {
        Matcher inputTagMatcher = INPUT_TAG_PATTERN.matcher(body);
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        while (inputTagMatcher.find()) {
            String tag = inputTagMatcher.group(0);
            Matcher nameMatcher = NAME_PATTERN.matcher(tag);
            Matcher valueMatcher = VALUE_PATTERN.matcher(tag);
            if (!nameMatcher.find()) continue;
            String nameValue = this.decodeHtmlCharacterReferences(nameMatcher.group(1));
            if (nameValue.contains("user") || nameValue.contains("email")) {
                parameters.add((NameValuePair)new BasicNameValuePair(nameValue, this.username));
                continue;
            }
            if (nameValue.contains("pass")) {
                parameters.add((NameValuePair)new BasicNameValuePair(nameValue, this.password));
                continue;
            }
            if (nameValue.isEmpty() || nameValue == null || !valueMatcher.find()) continue;
            parameters.add((NameValuePair)new BasicNameValuePair(nameValue, this.decodeHtmlCharacterReferences(valueMatcher.group(1))));
        }
        return parameters;
    }

    public static class Builder {
        private String username;
        private String password;
        private String hostName;
        private String partnerSpId;
        private Integer portNumber;
        private String preferredRole;
        private Integer roleSessionDuration;
        private Region region;
        private boolean lakeFormationEnabled;
        private Supplier<CloseableHttpClient> httpClientFactory;
        private AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory;
        private AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory;
        private StsClientBuilder stsClientFactory;
        private LakeFormationClientBuilder lakeFormationClientFactory;
        private Map<ConnectionParameter<?>, String> parameters;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder partnerSpId(String partnerSpId) {
            this.partnerSpId = partnerSpId;
            return this;
        }

        public Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder preferredRole(String preferredRole) {
            this.preferredRole = preferredRole;
            return this;
        }

        public Builder roleSessionDuration(Integer roleSessionDuration) {
            this.roleSessionDuration = roleSessionDuration;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder lakeFormationEnabled(boolean lakeFormationEnabled) {
            this.lakeFormationEnabled = lakeFormationEnabled;
            return this;
        }

        Builder httpClientFactory(Supplier<CloseableHttpClient> httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            return this;
        }

        Builder assumeRoleWithSamlRequestFactory(AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory) {
            this.assumeRoleWithSamlRequestFactory = assumeRoleWithSamlRequestFactory;
            return this;
        }

        Builder assumeDecoratedRoleWithSamlRequestFactory(AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory) {
            this.assumeDecoratedRoleWithSamlRequestFactory = assumeDecoratedRoleWithSamlRequestFactory;
            return this;
        }

        Builder stsClientBuilder(StsClientBuilder stsClientFactory) {
            this.stsClientFactory = stsClientFactory;
            return this;
        }

        Builder lakeFormationClientBuilder(LakeFormationClientBuilder lakeFormationClientFactory) {
            this.lakeFormationClientFactory = lakeFormationClientFactory;
            return this;
        }

        public Builder connectionParameters(Map<ConnectionParameter<?>, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public PingCredentialsProvider build() {
            return new PingCredentialsProvider(this.username, this.password, this.hostName, this.portNumber, this.partnerSpId, this.preferredRole, this.roleSessionDuration, this.region, this.httpClientFactory, this.assumeRoleWithSamlRequestFactory, this.stsClientFactory, this.assumeDecoratedRoleWithSamlRequestFactory, this.lakeFormationClientFactory, this.lakeFormationEnabled, this.parameters);
        }
    }
}

