/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.results.parsing.GetQueryResultsParser;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.services.athena.model.Row;

public class ResultPage {
    private final ResultSetMetadata resultSetMetadata;
    private final Long updateCount;
    private final List<String[]> rows;
    private final String nextToken;

    static ResultPage of(GetQueryResultsResponse response, GetQueryResultsParser resultParser) {
        List<String[]> rows = response.resultSet().rows().stream().map(row -> resultParser.parse((Row)row, response.resultSet().resultSetMetadata().columnInfo().size())).collect(Collectors.toList());
        return new ResultPage(response.resultSet().resultSetMetadata(), response.updateCount(), rows, response.nextToken());
    }

    ResultPage copyWithResultSetMetadata(ResultSetMetadata newResultSetMetadata) {
        return new ResultPage(newResultSetMetadata, this.updateCount, this.rows, this.nextToken);
    }

    @Generated
    public ResultPage(ResultSetMetadata resultSetMetadata, Long updateCount, List<String[]> rows, String nextToken) {
        this.resultSetMetadata = resultSetMetadata;
        this.updateCount = updateCount;
        this.rows = rows;
        this.nextToken = nextToken;
    }

    @Generated
    public ResultSetMetadata resultSetMetadata() {
        return this.resultSetMetadata;
    }

    @Generated
    public Long updateCount() {
        return this.updateCount;
    }

    @Generated
    public List<String[]> rows() {
        return this.rows;
    }

    @Generated
    public String nextToken() {
        return this.nextToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultPage)) {
            return false;
        }
        ResultPage other = (ResultPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$updateCount = this.updateCount();
        Long other$updateCount = other.updateCount();
        if (this$updateCount == null ? other$updateCount != null : !((Object)this$updateCount).equals(other$updateCount)) {
            return false;
        }
        ResultSetMetadata this$resultSetMetadata = this.resultSetMetadata();
        ResultSetMetadata other$resultSetMetadata = other.resultSetMetadata();
        if (this$resultSetMetadata == null ? other$resultSetMetadata != null : !this$resultSetMetadata.equals(other$resultSetMetadata)) {
            return false;
        }
        List<String[]> this$rows = this.rows();
        List<String[]> other$rows = other.rows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        String this$nextToken = this.nextToken();
        String other$nextToken = other.nextToken();
        return !(this$nextToken == null ? other$nextToken != null : !this$nextToken.equals(other$nextToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultPage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $updateCount = this.updateCount();
        result = result * 59 + ($updateCount == null ? 43 : ((Object)$updateCount).hashCode());
        ResultSetMetadata $resultSetMetadata = this.resultSetMetadata();
        result = result * 59 + ($resultSetMetadata == null ? 43 : $resultSetMetadata.hashCode());
        List<String[]> $rows = this.rows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        String $nextToken = this.nextToken();
        result = result * 59 + ($nextToken == null ? 43 : $nextToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResultPage(resultSetMetadata=" + this.resultSetMetadata() + ", updateCount=" + this.updateCount() + ", rows=" + this.rows() + ", nextToken=" + this.nextToken() + ")";
    }
}

