/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.error;

import com.amazon.athena.client.error.QueryExecutionCancelledException;
import com.amazon.athena.client.error.QueryExecutionFailedException;
import java.util.Optional;
import software.amazon.awssdk.services.athena.model.AthenaError;
import software.amazon.awssdk.services.athena.model.QueryExecution;

public class QueryExecutionException
extends Exception {
    private final QueryExecution queryExecution;

    public QueryExecutionException(QueryExecution queryExecution) {
        super(queryExecution.status().stateChangeReason() != null ? queryExecution.status().stateChangeReason() : null);
        this.queryExecution = queryExecution;
    }

    public QueryExecutionException(QueryExecution queryExecution, String message) {
        super(message);
        this.queryExecution = queryExecution;
    }

    public QueryExecutionException(QueryExecution queryExecution, String message, Throwable cause) {
        super(message, cause);
        this.queryExecution = queryExecution;
    }

    public static QueryExecutionException of(QueryExecution queryExecution) {
        switch (queryExecution.status().state()) {
            case FAILED: {
                return new QueryExecutionFailedException(queryExecution);
            }
            case CANCELLED: {
                return new QueryExecutionCancelledException(queryExecution);
            }
        }
        throw new IllegalArgumentException(String.format("No QueryExecutionException subclass for the \"%s\" state", queryExecution.status().state()));
    }

    public QueryExecution queryExecution() {
        return this.queryExecution;
    }

    public Optional<Integer> athenaErrorCategory() {
        return Optional.ofNullable(this.queryExecution.status().athenaError()).map(AthenaError::errorCategory);
    }

    public Optional<Integer> athenaErrorType() {
        return Optional.ofNullable(this.queryExecution.status().athenaError()).map(AthenaError::errorType);
    }
}

