/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataRole;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class TeradataRoleMember
implements DBSObject {
    private static final Log log = Log.getLog(TeradataRoleMember.class);
    private TeradataDatasource datasource;
    private TeradataRole teradataRole;
    private DBAObject grantee;
    private GranteeKind granteeKind;
    private String grantor;
    private Date whenGranted;
    private boolean defaultRole;
    private boolean withAdmin;

    public TeradataRoleMember(@NotNull DBRProgressMonitor monitor, @NotNull TeradataDatasource datasource, @NotNull TeradataRole teradataRole, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.teradataRole = teradataRole;
        this.granteeKind = (GranteeKind)CommonUtils.valueOf(GranteeKind.class, (String)JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GranteeKind"), (Enum)GranteeKind.User);
        String granteeName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"Grantee");
        if (CommonUtils.isNotEmpty((String)granteeName)) {
            if (this.granteeKind == GranteeKind.Role) {
                try {
                    this.grantee = datasource.getRole(monitor, granteeName);
                }
                catch (DBException dBException) {
                    log.debug((Object)("Can't find role " + granteeName));
                }
            } else {
                try {
                    this.grantee = datasource.getUser(monitor, granteeName);
                }
                catch (DBException dBException) {
                    log.debug((Object)("Can't find user " + granteeName));
                }
            }
        }
        this.grantor = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"Grantor");
        this.whenGranted = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"WhenGranted");
        this.defaultRole = "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DefaultRole"));
        this.withAdmin = "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"WithAdmin"));
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.teradataRole;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    public DBAObject getGrantee() {
        return this.grantee;
    }

    @Property(viewable=true, order=2)
    public GranteeKind getGranteeKind() {
        return this.granteeKind;
    }

    @Property(viewable=true, order=3)
    public String getGrantor() {
        return this.grantor;
    }

    @Property(viewable=true, order=4)
    public Date getWhenGranted() {
        return this.whenGranted;
    }

    @Property(viewable=true, order=5)
    public boolean isDefaultRole() {
        return this.defaultRole;
    }

    @Property(viewable=true, order=6)
    public boolean isWithAdmin() {
        return this.withAdmin;
    }

    @NotNull
    public String getName() {
        return this.teradataRole.getName() + "_" + this.grantee.getName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    static enum GranteeKind {
        User,
        Role;

    }
}

