/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeSchema;
import com.dbeaver.db.snowflake.model.SnowflakeUtils;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SnowflakeTask
implements DBSObject,
DBPQualifiedObject,
GenericScriptObject,
DBPRefreshableObject {
    private SnowflakeSchema schema;
    private String name;
    private String id;
    private String taskOwner;
    private String warehouse;
    private String schedule;
    private String state;
    private String condition;
    private String allowOverlappingExecution;
    private Date created;
    private Date lastCommittedOn;
    private Date lastSuspendedOn;
    private String description;
    private String source;

    SnowflakeTask(@NotNull SnowflakeSchema schema, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.schema = schema;
        this.name = name;
        this.id = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"id");
        this.taskOwner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"owner");
        this.warehouse = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"warehouse");
        this.schedule = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"schedule");
        this.state = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"state");
        this.condition = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"condition");
        this.allowOverlappingExecution = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"allow_overlapping_execution");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"created_on");
        this.lastCommittedOn = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"last_committed_on");
        this.lastSuspendedOn = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"last_suspended_on");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"comment");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.schema;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getId() {
        return this.id;
    }

    @Property(viewable=true, order=3)
    public String getTaskOwner() {
        return this.taskOwner;
    }

    @Property(viewable=true, order=4)
    public String getWarehouse() {
        return this.warehouse;
    }

    @Property(viewable=true, order=5)
    public String getSchedule() {
        return this.schedule;
    }

    @Property(viewable=true, order=6)
    public String getState() {
        return this.state;
    }

    @Property(viewable=true, order=7)
    public String getCondition() {
        return this.condition;
    }

    @Property(viewable=true, order=8)
    public String getAllowOverlappingExecution() {
        return this.allowOverlappingExecution;
    }

    @Property(viewable=true, order=9)
    public Date getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=10)
    public Date getLastCommittedOn() {
        return this.lastCommittedOn;
    }

    @Property(viewable=true, order=11)
    public Date getLastSuspendedOn() {
        return this.lastSuspendedOn;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=30)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String comment) {
        this.description = comment;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.schema.getCatalog() != null ? DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema.getCatalog(), this.schema, this}) : DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema, this});
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.source = null;
        return this;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = SnowflakeUtils.getObjectDDL(monitor, this, "TASK", null);
        }
        return this.source;
    }
}

