/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeSchema;
import com.dbeaver.db.snowflake.model.SnowflakeUtils;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SnowflakePipe
implements DBSObject,
DBPQualifiedObject,
GenericScriptObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(SnowflakePipe.class);
    private SnowflakeSchema schema;
    private String name;
    private String pipeOwner;
    private boolean isAutoIngestEnabled;
    private String channelName;
    private String pattern;
    private String pipeDefinition;
    private String description;
    private Date created;
    private Date lastAltered;
    private String source;

    SnowflakePipe(@NotNull SnowflakeSchema schema, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.schema = schema;
        this.name = name;
        this.pipeOwner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PIPE_OWNER");
        this.isAutoIngestEnabled = "YES".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"IS_AUTOINGEST_ENABLED"));
        this.channelName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"NOTIFICATION_CHANNEL_NAME");
        this.pattern = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PATTERN");
        this.pipeDefinition = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DEFINITION");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"COMMENT");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_ALTERED");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.schema;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getPipeOwner() {
        return this.pipeOwner;
    }

    @Property(viewable=true, order=3)
    public String getChannelName() {
        return this.channelName;
    }

    @Property(viewable=true, order=4)
    public String getPattern() {
        return this.pattern;
    }

    @Property(viewable=true, order=5)
    public boolean isAutoIngestEnabled() {
        return this.isAutoIngestEnabled;
    }

    @Property(viewable=true, order=6)
    public Date getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=7)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=30)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String comment) {
        this.description = comment;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.schema.getCatalog() != null ? DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema.getCatalog(), this.schema, this}) : DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema, this});
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        if (this.source == null) {
            try {
                this.source = SnowflakeUtils.getObjectDDL(monitor, this, "PIPE", null);
            }
            catch (DBException e) {
                log.debug((Object)"Can't read the pipe DDL from the server-side", (Throwable)e);
                this.source = CommonUtils.isNotEmpty((String)this.pipeDefinition) ? "CREATE OE REPLACE PIPE " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + "\nAS " + this.pipeDefinition : "<Pipe definition is not available>";
            }
        }
        return this.source;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.source = null;
        return this;
    }
}

