/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.edit;

import com.dbeaver.db.snowflake.model.SnowflakeProcedure;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericProcedureManager;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SnowflakeProcedureManager
extends GenericProcedureManager
implements DBEObjectRenamer<GenericProcedure> {
    public boolean canCreateObject(@NotNull Object container) {
        return true;
    }

    protected GenericProcedure createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object from, @NotNull Map<String, Object> options) {
        if (container instanceof GenericStructContainer) {
            GenericStructContainer structContainer = (GenericStructContainer)container;
            return new SnowflakeProcedure(structContainer, "NEW_PROCEDURE");
        }
        throw new IllegalStateException("Not implemented");
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (GenericProcedure)command.getObject(), executionContext);
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        if (command.getProperties().size() > 1 || !command.hasProperty((Object)"description")) {
            this.createOrReplaceProcedureQuery(actionList, (GenericProcedure)command.getObject(), executionContext);
        }
    }

    private void createOrReplaceProcedureQuery(@NotNull List<DBEPersistAction> actions, @NotNull GenericProcedure procedure, @NotNull DBCExecutionContext executionContext) {
        boolean changeCatalog;
        GenericCatalog defaultCatalog = null;
        if (executionContext instanceof GenericExecutionContext) {
            defaultCatalog = ((GenericExecutionContext)executionContext).getDefaultCatalog();
        }
        GenericCatalog procedureCatalog = procedure.getCatalog();
        boolean bl = changeCatalog = defaultCatalog != null && procedureCatalog != null;
        if (changeCatalog && defaultCatalog != procedureCatalog) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database", "USE DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)procedureCatalog), false));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create procedure", procedure.getSource(), true));
        if (changeCatalog && defaultCatalog != procedureCatalog) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Return default database", "USE DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)defaultCatalog), false));
        }
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericProcedure, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        GenericProcedure procedure = (GenericProcedure)command.getObject();
        String procedureFullName = this.getProcedureFullNameWithParameters(monitor, procedure);
        String description = procedure.getDescription();
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "ALTER " + procedure.getProcedureType().name() + " " + procedureFullName + " SET COMMENT = " + SQLUtils.quoteString((DBSObject)procedure, (String)CommonUtils.notEmpty((String)description))));
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericProcedure object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        GenericProcedure procedure = (GenericProcedure)command.getObject();
        Object fullName = DBUtils.getQuotedIdentifier((DBPDataSource)procedure.getDataSource(), (String)command.getNewName());
        DBSObject schema = procedure.getParentObject();
        if (schema != null) {
            fullName = DBUtils.getQuotedIdentifier((DBSObject)schema) + "." + (String)fullName;
            DBSObject catalog = schema.getParentObject();
            if (catalog != null) {
                fullName = DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." + (String)fullName;
            }
        }
        String procedureFullName = this.getProcedureFullNameWithParameters(monitor, procedure);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename procedure", "ALTER " + procedure.getProcedureType().name() + " " + procedureFullName + " RENAME TO " + (String)fullName));
    }

    private String getProcedureFullNameWithParameters(DBRProgressMonitor monitor, @NotNull GenericProcedure procedure) {
        String procedureFullName;
        try {
            procedureFullName = procedure.getProcedureSignature(monitor, false);
        }
        catch (DBException e) {
            log.debug((Object)"Can't read procedure/function parameters", (Throwable)e);
            procedureFullName = procedure.getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        return procedureFullName;
    }
}

