/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.edit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerJob;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class OracleSchedulerJobManager
extends SQLObjectEditor<OracleSchedulerJob, OracleSchema> {
    private static final String TIMESTAMP_FORMAT = "^\\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d\\.\\d{6} [+-]\\d{1,2}:[0-5]\\d$";

    protected OracleSchedulerJob createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new OracleSchedulerJob((OracleSchema)container, "NEW_SCHEDULER_JOB", OracleSchedulerJob.JobState.DISABLED.name(), "");
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        Map properties = command.getProperties();
        OracleSchedulerJob schedulerJob = (OracleSchedulerJob)command.getObject();
        String owner = ((OracleSchema)schedulerJob.getParentObject()).getName();
        String jobFullNameQuoted = this.getJobFullNameQuoted(schedulerJob, owner);
        String jobType = properties.get("jobType").toString();
        String actionStr = properties.get("jobAction").toString();
        Object nlsEnv = properties.get("nlsEnv");
        if (nlsEnv != null) {
            actionList.add((DBEPersistAction)this.modifyNlsEnv(nlsEnv));
        }
        String createJobSQL = String.format("BEGIN\n  DBMS_SCHEDULER.CREATE_JOB(\n    job_name            => %s,\n    job_type            => %s,\n    job_action          => %s\n  );\n", jobFullNameQuoted, SQLUtils.quoteString((DBSObject)schedulerJob, (String)jobType), SQLUtils.quoteString((DBSObject)schedulerJob, (String)actionStr));
        Set<String> mainParams = Set.of("name", "jobType", "jobAction", "enabled", "nlsEnv");
        StringBuilder setAttrPlsql = new StringBuilder(createJobSQL);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String attribute;
            String string = attribute = "description".equals(entry.getKey().toString()) ? "comments" : entry.getKey().toString();
            if (mainParams.contains(attribute)) continue;
            this.setDbmsSchedulerJobAttribute(schedulerJob, jobFullNameQuoted, setAttrPlsql, entry, attribute);
        }
        this.enableOrDisableIfPresent(properties, setAttrPlsql, jobFullNameQuoted);
        setAttrPlsql.append("  COMMIT;\nEND;");
        String string = setAttrPlsql.toString();
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create scheduler job", string));
        if (string.contains("DBMS_SCHEDULER.SET_ATTRIBUTE")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set Additional Scheduler Job Attributes", string));
        }
    }

    private void setDbmsSchedulerJobAttribute(OracleSchedulerJob schedulerJob, String jobFullNameQuoted, StringBuilder setAttrPlsql, Map.Entry<Object, Object> entry, String attribute) {
        Object valueObj = entry.getValue();
        if (valueObj == null) {
            return;
        }
        String formattedValue = this.getFormattedValue(valueObj, attribute, schedulerJob);
        String attributeUnderScore = SQLUtils.quoteString((DBSObject)schedulerJob, (String)OracleSchedulerJobManager.camelCaseToUnderScore(attribute));
        setAttrPlsql.append(String.format("DBMS_SCHEDULER.SET_ATTRIBUTE(\n  name      => %s,\n  attribute => %s,\n  value     => %s\n);\n", jobFullNameQuoted, attributeUnderScore, formattedValue));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        Map properties = command.getProperties();
        OracleSchedulerJob schedulerJob = (OracleSchedulerJob)command.getObject();
        String owner = ((OracleSchema)schedulerJob.getParentObject()).getName();
        Object nlsEnv = properties.get("nlsEnv");
        if (nlsEnv != null) {
            actionList.add((DBEPersistAction)this.modifyNlsEnv(nlsEnv));
        }
        String jobFullNameQuoted = this.getJobFullNameQuoted(schedulerJob, owner);
        StringBuilder plsql = new StringBuilder("BEGIN\n");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String attribute;
            String string = attribute = "description".equals(entry.getKey().toString()) ? "comments" : entry.getKey().toString();
            if (attribute.equals("enabled")) continue;
            this.setDbmsSchedulerJobAttribute(schedulerJob, jobFullNameQuoted, plsql, entry, attribute);
        }
        this.enableOrDisableIfPresent(properties, plsql, jobFullNameQuoted);
        plsql.append("  COMMIT;\nEND;");
        String string = plsql.toString();
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Update Scheduler Job", string));
    }

    private String getFormattedValue(Object valueObj, String attribute, OracleSchedulerJob schedulerJob) {
        String formattedValue = "";
        if (valueObj instanceof Number) {
            Number numberVal = (Number)valueObj;
            formattedValue = String.valueOf(numberVal);
        } else if (attribute.toLowerCase(Locale.ROOT).contains("date")) {
            formattedValue = this.formatTimestamp(schedulerJob, valueObj.toString());
        } else if (valueObj instanceof String) {
            String stringVal = (String)valueObj;
            formattedValue = "instanceStickiness".equals(attribute) || "loggingLevel".equals(attribute) || "autoDrop".equals(attribute) || "restartable".equals(attribute) || "instanceId".equals(attribute) ? stringVal : SQLUtils.quoteString((DBSObject)schedulerJob, (String)stringVal);
        } else {
            formattedValue = valueObj.toString();
        }
        return formattedValue;
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        OracleSchedulerJob schedulerJob = (OracleSchedulerJob)command.getObject();
        String owner = ((OracleSchema)schedulerJob.getParentObject()).getName();
        String jobFullNameQuoted = this.getJobFullNameQuoted(schedulerJob, owner);
        String sql = String.format("BEGIN\n  DBMS_SCHEDULER.DROP_JOB(%s);\nEND;\n", jobFullNameQuoted);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Delete Scheduled Job", sql));
    }

    private String getJobFullNameQuoted(OracleSchedulerJob schedulerJob, String owner) {
        return SQLUtils.quoteString((DBSObject)schedulerJob, (String)(owner + "." + schedulerJob.getName()));
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleSchedulerJob> getObjectsCache(OracleSchedulerJob object) {
        return object.getSchema().schedulerJobCache;
    }

    private String formatTimestamp(OracleSchedulerJob oracleJob, String timestamp) {
        return timestamp.matches(TIMESTAMP_FORMAT) ? "TO_TIMESTAMP_TZ(%s, 'yyyy-mm-dd hh24:mi:ss.ff tzr')".formatted(SQLUtils.quoteString((DBSObject)oracleJob, (String)timestamp)) : timestamp;
    }

    private void enableOrDisableIfPresent(Map<Object, Object> properties, StringBuilder setAttrPlsql, String jobFullNameQuoted) {
        Object enabled = properties.get("enabled");
        if (enabled != null) {
            String enabledVal = enabled.toString();
            if (enabledVal.equalsIgnoreCase("true")) {
                setAttrPlsql.append("  DBMS_SCHEDULER.ENABLE(").append(jobFullNameQuoted).append(");\n");
            } else {
                setAttrPlsql.append("  DBMS_SCHEDULER.DISABLE(").append(jobFullNameQuoted).append(");\n");
            }
        }
    }

    private SQLDatabasePersistAction modifyNlsEnv(@NotNull Object nlsEnv) {
        String sql = String.format("ALTER SESSION SET %s", nlsEnv);
        return new SQLDatabasePersistAction("Edit NLS ENV", sql);
    }

    private static String camelCaseToUnderScore(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    result.append('_');
                }
                result.append(Character.toLowerCase(ch));
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }
}

