/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.navigator;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.TBProject;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.TBVirtualConnection;
import com.dbeaver.model.tableau.TBWorkbook;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceNode;
import com.dbeaver.model.tableau.navigator.DBNTableauFolder;
import com.dbeaver.model.tableau.navigator.DBNTableauFolderContainerNode;
import com.dbeaver.model.tableau.navigator.DBNTableauFolderNode;
import com.dbeaver.model.tableau.navigator.DBNTableauProfileNode;
import com.dbeaver.model.tableau.navigator.DBNTableauProjectNode;
import com.dbeaver.model.tableau.navigator.DBNTableauVirtualConnectionNode;
import com.dbeaver.model.tableau.navigator.DBNTableauWorkbookNode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNTableauSiteNode
extends DBNTableauFolderContainerNode
implements DBNObjectNode {
    private static final Log log = Log.getLog(DBNTableauSiteNode.class);
    public static DBNTableauFolder<DBNTableauSiteNode> FOLDER_DATASOURCES = new DBNTableauFolder<DBNTableauSiteNode>("Data Sources", "Data sources and database connections", (DBPImage)DBIcon.TREE_FOLDER_DATABASE){

        public DBNTableauDataSourceNode[] loadChildren(DBRProgressMonitor monitor, DBNTableauSiteNode ownerNode, DBNTableauFolderNode<DBNTableauSiteNode> folderNode) throws DBException {
            return (DBNTableauDataSourceNode[])ownerNode.getSite().getDataSources(monitor).stream().map(ds -> new DBNTableauDataSourceNode(folderNode, (TBDataSource)ds)).toArray(DBNTableauDataSourceNode[]::new);
        }

        @Override
        public void refreshChildren(DBNTableauSiteNode ownerNode) {
            ownerNode.getSite().refreshObject();
        }
    };
    public static DBNTableauFolder<DBNTableauSiteNode> FOLDER_WORKBOOKS = new DBNTableauFolder<DBNTableauSiteNode>("Workbooks", "Site workbooks", (DBPImage)DBIcon.TREE_FOLDER_SCHEMA){

        @Override
        public DBNNode[] loadChildren(DBRProgressMonitor monitor, DBNTableauSiteNode ownerNode, DBNTableauFolderNode<DBNTableauSiteNode> folderNode) throws DBException {
            return (DBNNode[])ownerNode.getSite().getWorkbooks(monitor).stream().map(wb -> new DBNTableauWorkbookNode(folderNode, (TBWorkbook)wb)).toArray(DBNTableauWorkbookNode[]::new);
        }

        @Override
        public void refreshChildren(DBNTableauSiteNode ownerNode) {
            ownerNode.getSite().refreshObject();
        }
    };
    public static DBNTableauFolder<DBNTableauSiteNode> FOLDER_VIRTUAL_CONNECTIONS = new DBNTableauFolder<DBNTableauSiteNode>("Virtual Connections", "Virtual connections", (DBPImage)DBIcon.TREE_FOLDER_DATABASE){

        public DBNTableauVirtualConnectionNode[] loadChildren(DBRProgressMonitor monitor, DBNTableauSiteNode ownerNode, DBNTableauFolderNode<DBNTableauSiteNode> folderNode) throws DBException {
            return (DBNTableauVirtualConnectionNode[])ownerNode.getSite().getVirtualConnections(monitor).stream().map(vc -> new DBNTableauVirtualConnectionNode(folderNode, (TBVirtualConnection)vc)).toArray(DBNTableauVirtualConnectionNode[]::new);
        }

        @Override
        public void refreshChildren(DBNTableauSiteNode ownerNode) {
            ownerNode.getSite().refreshObject();
        }
    };
    public static DBNTableauFolder<DBNTableauSiteNode> FOLDER_PROJECTS = new DBNTableauFolder<DBNTableauSiteNode>("Projects", "Site projects", (DBPImage)DBIcon.TREE_SCRIPT_FOLDER){

        @Override
        public DBNNode[] loadChildren(DBRProgressMonitor monitor, DBNTableauSiteNode ownerNode, DBNTableauFolderNode<DBNTableauSiteNode> folderNode) throws DBException {
            return (DBNNode[])ownerNode.getSite().getRootProjects(monitor).stream().map(p -> new DBNTableauProjectNode(folderNode, (TBProject)p)).toArray(DBNTableauProjectNode[]::new);
        }

        @Override
        public void refreshChildren(DBNTableauSiteNode ownerNode) {
            ownerNode.getSite().refreshObject();
        }
    };
    private final TBSite site;

    DBNTableauSiteNode(DBNTableauProfileNode parentNode, TBSite site) {
        super(parentNode);
        this.site = site;
    }

    public TBSite getSite() {
        return this.site;
    }

    public TBSession getSession() {
        return this.site.getSession();
    }

    @NotNull
    public String getNodeType() {
        return "Tableau site";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.site.getName();
    }

    @Nullable
    public String getNodeDescription() {
        return "Tableau site";
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TYPE_OBJECT;
    }

    protected boolean allowsChildren() {
        return true;
    }

    protected DBNTableauFolderNode[] createFolders(DBRProgressMonitor monitor) {
        return new DBNTableauFolderNode[]{new DBNTableauFolderNode<DBNTableauSiteNode>(this, FOLDER_DATASOURCES), new DBNTableauFolderNode<DBNTableauSiteNode>(this, FOLDER_WORKBOOKS), new DBNTableauFolderNode<DBNTableauSiteNode>(this, FOLDER_PROJECTS)};
    }

    @Override
    @NotNull
    public String toString() {
        return this.getNodeDisplayName();
    }

    public Object getNodeObject() {
        return this.site;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.site.refreshObject();
        return super.refreshNode(monitor, source);
    }
}

