/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.model.tableau.rest.api.ErrorType;
import com.dbeaver.model.tableau.rest.api.ServerInfo;
import com.dbeaver.model.tableau.rest.api.SiteType;
import com.dbeaver.model.tableau.rest.api.TableauCredentialsType;
import com.dbeaver.model.tableau.rest.api.TsRequest;
import com.dbeaver.model.tableau.rest.api.TsResponse;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.NullHostnameVerifier;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class TBSession {
    private static final Log log = Log.getLog(TBSession.class);
    private final TBAuthProfile authProfile;
    private String authToken;
    private SiteType authSite;
    private JAXBContext jaxbContext;
    private OkHttpClient httpClient;
    private List<TBSite> sites;
    private ServerInfo serverInfo;

    public TBSession(TBAuthProfile authProfile) {
        this.authProfile = authProfile;
    }

    public TBAuthProfile getAuthProfile() {
        return this.authProfile;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getSiteId() {
        return this.authSite.getId();
    }

    public void login(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Open Tableau session", 3);
        this.authProfile.resolveCredentials();
        try {
            try {
                this.initClient(monitor);
                monitor.worked(1);
                TsRequest tsRequest = new TsRequest();
                TableauCredentialsType tableauCredentials = new TableauCredentialsType();
                switch (this.authProfile.getAuthType()) {
                    case USER_PASSWORD: {
                        tableauCredentials.setName(this.authProfile.getUserName());
                        tableauCredentials.setPassword(this.authProfile.getUserPassword());
                        break;
                    }
                    case USER_TOKEN: {
                        tableauCredentials.setPersonalAccessTokenName(this.authProfile.getUserTokenName());
                        tableauCredentials.setPersonalAccessTokenSecret(this.authProfile.getUserTokenValue());
                    }
                }
                SiteType siteType = new SiteType();
                siteType.setContentUrl(this.authProfile.getSiteId());
                tableauCredentials.setSite(siteType);
                tsRequest.setCredentials(tableauCredentials);
                StringWriter sw = new StringWriter();
                this.createMarshaller().marshal((Object)tsRequest, (Writer)sw);
                this.serverInfo = this.getServerInfo(monitor);
                String signinEndpoint = this.makeApiURL() + "auth/signin/";
                HttpUrl url = HttpUrl.parse((String)signinEndpoint);
                Request httpRequest = new Request.Builder().url(url).post(RequestBody.create((String)sw.toString(), (MediaType)MediaType.get((String)"application/xml"))).build();
                Call call = this.httpClient.newCall(httpRequest);
                monitor.subTask("Authenticate");
                Response response = call.execute();
                monitor.worked(1);
                monitor.subTask("Finish authentication");
                String stringEntity = response.body().string();
                TsResponse tsResponse = this.parseResponse(stringEntity, this.jaxbContext);
                ErrorType error = tsResponse.getError();
                if (error != null) {
                    throw new DBException("Login error: " + error.getDetail() + " (" + String.valueOf(error.getCode()) + ")");
                }
                TableauCredentialsType credentials = tsResponse.getCredentials();
                this.authToken = credentials.getToken();
                this.authSite = credentials.getSite();
            }
            catch (Exception e) {
                throw new DBException("Tableau auth error", (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    private String makeApiURL() {
        String signinEndpoint = this.authProfile.getSiteURL();
        String apiVersion = this.serverInfo == null ? "3.0" : this.serverInfo.getRestApiVersion();
        return CommonUtils.removeTrailingSlash((String)signinEndpoint) + "/api/" + apiVersion + "/";
    }

    Marshaller createMarshaller() throws JAXBException {
        return this.jaxbContext.createMarshaller();
    }

    public ServerInfo getServerInfo(DBRProgressMonitor monitor) throws DBException {
        return this.executeRequest(monitor, "serverinfo").getServerInfo();
    }

    public List<TBSite> getSites(DBRProgressMonitor monitor) throws DBException {
        if (this.sites == null) {
            this.sites = this.loadSites(monitor);
        }
        return this.sites;
    }

    public TBSite getSite(DBRProgressMonitor monitor, String siteId) throws DBException {
        if (this.sites == null) {
            this.sites = this.loadSites(monitor);
        }
        return this.sites.stream().filter(tbSite -> tbSite.getId().equals(siteId)).findFirst().orElse(null);
    }

    private List<TBSite> loadSites(DBRProgressMonitor monitor) throws DBException {
        return Collections.singletonList(new TBSite(this, this.authSite));
    }

    private void initClient(DBRProgressMonitor monitor) throws JAXBException {
        if (this.httpClient != null) {
            return;
        }
        monitor.subTask("Initialize connector");
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TsRequest.class, TsResponse.class});
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(100L, TimeUnit.SECONDS);
        if (this.authProfile.isTrustServerCertificate()) {
            builder.hostnameVerifier((HostnameVerifier)NullHostnameVerifier.INSTANCE);
        }
        this.httpClient = builder.build();
    }

    /*
     * Loose catch block
     */
    TsResponse executeRequest(DBRProgressMonitor monitor, String endpoint) throws DBException {
        monitor.subTask("Execute HTTP request " + endpoint);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Response response = this.executeHttpRequest(endpoint);){
            TsResponse tsResponse;
            ResponseBody body;
            Throwable throwable2;
            block23: {
                throwable2 = null;
                Object var7_11 = null;
                body = response.body();
                if (body == null) {
                    throw new DBException("Empty response body: " + String.valueOf(response));
                }
                String stringEntity = body.string();
                TsResponse tsResponse2 = this.parseResponse(stringEntity, this.jaxbContext);
                if (tsResponse2.getError() != null) {
                    throw new DBException(tsResponse2.getError().getDetail());
                }
                tsResponse = tsResponse2;
                if (body == null) break block23;
                body.close();
            }
            return tsResponse;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            if (body != null) {
                                body.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new DBException("IO error while reading response body", (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    Response executeHttpRequest(String endpoint) throws DBException {
        String urlString = this.makeApiURL() + endpoint;
        HttpUrl url = HttpUrl.parse((String)urlString);
        Request.Builder builder = new Request.Builder().url(url).method("GET", null);
        if (this.authToken != null) {
            builder.header("X-Tableau-Auth", this.authToken);
        }
        Request httpRequest = builder.build();
        try {
            return this.httpClient.newCall(httpRequest).execute();
        }
        catch (IOException e) {
            throw new DBException("IO error while executing REST", (Throwable)e);
        }
    }

    Response executeHttpPostRequest(String endpoint, MultipartBody requestPayload) throws DBException {
        String urlString = this.makeApiURL() + endpoint;
        HttpUrl url = HttpUrl.parse((String)urlString);
        Request.Builder builder = new Request.Builder().url(url);
        if (this.authToken != null) {
            builder.header("X-Tableau-Auth", this.authToken);
        }
        Request httpRequest = builder.post((RequestBody)requestPayload).build();
        try {
            return this.httpClient.newCall(httpRequest).execute();
        }
        catch (IOException e) {
            throw new DBException("IO error while executing REST", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    TsResponse executeFileRequest(DBRProgressMonitor monitor, String endpoint, String uploadForm, Path file) throws DBException {
        monitor.subTask("Execute HTTP multipart request " + endpoint);
        MultipartBody requestPayload = new MultipartBody.Builder().addPart(Headers.of((String[])new String[]{"Content-Disposition", "name=\"request_payload\""}), RequestBody.create((String)uploadForm, (MediaType)MediaType.get((String)"text/xml"))).addPart(Headers.of((String[])new String[]{"Content-Disposition", "name=\"tableau_datasource\"; filename=\"" + file.getFileName().toString() + "\""}), RequestBody.create((File)file.toFile(), (MediaType)MediaType.get((String)"octet/stream"))).build();
        Throwable throwable = null;
        Object var7_8 = null;
        try (Response response = this.executeHttpPostRequest(endpoint, requestPayload);){
            TsResponse tsResponse;
            ResponseBody body;
            Throwable throwable2;
            block23: {
                throwable2 = null;
                Object var10_14 = null;
                body = response.body();
                if (body == null) {
                    throw new DBException("Empty response body: " + String.valueOf(response));
                }
                String stringEntity = body.string();
                TsResponse tsResponse2 = this.parseResponse(stringEntity, this.jaxbContext);
                if (tsResponse2.getError() != null) {
                    throw new DBException(tsResponse2.getError().getDetail());
                }
                tsResponse = tsResponse2;
                if (body == null) break block23;
                body.close();
            }
            return tsResponse;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            if (body != null) {
                                body.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new DBException("IO error while reading response body", (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private TsResponse parseResponse(String stringEntity, JAXBContext jaxbContext) throws DBException {
        try {
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            jaxbUnmarshaller.setEventHandler(event -> {
                log.debug((Object)event.getMessage());
                return true;
            });
            XMLStreamReader xsr = XMLInputFactory.newFactory().createXMLStreamReader(new StringReader(stringEntity));
            return (TsResponse)jaxbUnmarshaller.unmarshal((XMLStreamReader)new XMLReaderWithoutNamespace(xsr));
        }
        catch (Exception e) {
            throw new DBException("Error parsing response", (Throwable)e);
        }
    }

    static class XMLReaderWithoutNamespace
    extends StreamReaderDelegate {
        public XMLReaderWithoutNamespace(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public String getAttributeNamespace(int arg0) {
            return "";
        }

        @Override
        public String getNamespaceURI() {
            String localName = this.getLocalName();
            if (!"tsResponse".equals(localName) && !"tsRequest".equals(localName)) {
                return "";
            }
            return super.getNamespaceURI();
        }
    }
}

