/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb;

import com.dbeaver.db.mongodb.data.MGDocument;
import com.dbeaver.db.mongodb.data.MGListValue;
import com.dbeaver.db.mongodb.data.handlers.MongoObjectValueHandler;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.model.document.data.DBDocumentElement;
import com.dbeaver.model.document.data.DBMapValue;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoCredential;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.utils.CommonUtils;

public class MGUtils {
    private static final Log log = Log.getLog(MGUtils.class);
    private static final char[] EMPTY_PASSWORD = "".toCharArray();

    public static int resolveValueType(Object value) {
        if (value instanceof CharSequence) {
            return 3;
        }
        if (value instanceof Number) {
            return 4;
        }
        if (value instanceof Boolean) {
            return 7;
        }
        if (value instanceof Date) {
            return 8;
        }
        if (value instanceof byte[]) {
            return 9;
        }
        if (value instanceof Collection) {
            return 10;
        }
        if (value instanceof MGDocument) {
            return 2;
        }
        if (value instanceof DBDocumentElement) {
            DBDocumentElement wrapper = (DBDocumentElement)value;
            return 1;
        }
        return 11;
    }

    public static Object wrapMongoValue(MGDataSource dataSource, Object value, Object parent) {
        Binary binary;
        byte binarySubtype;
        if (value instanceof Binary && ((binarySubtype = (binary = (Binary)value).getType()) == BsonBinarySubType.UUID_LEGACY.getValue() || binarySubtype == BsonBinarySubType.UUID_STANDARD.getValue())) {
            value = MongoObjectValueHandler.fromStandardBinaryUUID(binary);
        }
        if (value instanceof List) {
            return MGUtils.wrapMongoList(dataSource, (List)value, parent);
        }
        if (value instanceof Map) {
            return MGUtils.wrapMongoMap(dataSource, (Map)value, parent);
        }
        if (value instanceof ObjectId) {
            return new DBDocumentElement("ObjectId", value, DBMapValue.MapValueType.OBJECT_ID);
        }
        return value;
    }

    public static MGListValue wrapMongoList(MGDataSource dataSource, List<Object> dbList, Object parent) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : dbList) {
            list.add(MGUtils.wrapMongoValue(dataSource, item, parent));
        }
        return new MGListValue(dataSource, list);
    }

    @NotNull
    public static DBMapValue<MGDataSource> wrapMongoMap(MGDataSource dataSource, Map<String, Object> value, Object parent) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        DBMapValue mapValue = new DBMapValue((DBPDataSource)dataSource, parent, map);
        for (String name : value.keySet()) {
            Object mValue = value.get(name);
            map.put(name, MGUtils.wrapMongoValue(dataSource, mValue, mapValue));
        }
        return mapValue;
    }

    public static Object unwrapMongoValue(@NotNull MGDataSource dataSource, @Nullable DBSAttributeBase attribute, Object value) {
        return MGUtils.unwrapMongoValue(dataSource, attribute == null ? null : attribute.getName(), value);
    }

    public static Object unwrapMongoValue(@NotNull MGDataSource dataSource, @Nullable String name, Object value) {
        if (value instanceof UUID) {
            return MongoObjectValueHandler.toStandardBinaryUUID((UUID)value);
        }
        if (value instanceof MGDocument) {
            return MGUtils.unwrapMongoMap(dataSource, (DBMapValue<MGDataSource>)((MGDocument)((Object)value)).getRootNode());
        }
        if (value instanceof DBMapValue) {
            return MGUtils.unwrapMongoMap(dataSource, (DBMapValue<MGDataSource>)((DBMapValue)value));
        }
        if (value instanceof Map) {
            return MGUtils.unwrapPlainMap(dataSource, (Map)value);
        }
        if (value instanceof MGListValue) {
            return MGUtils.unwrapMongoList(dataSource, (MGListValue)((Object)value));
        }
        if (value instanceof BigDecimal && !dataSource.supportsDecimal128()) {
            value = ((BigDecimal)value).scale() == 0 ? (Number)((BigDecimal)value).longValue() : (Number)((BigDecimal)value).doubleValue();
        } else if (value instanceof DBDocumentElement) {
            DBDocumentElement wrapper = (DBDocumentElement)value;
            value = wrapper.objectValue();
        }
        return value;
    }

    private static Document unwrapMongoMap(MGDataSource dataSource, DBMapValue<MGDataSource> value) {
        return MGUtils.unwrapPlainMap(dataSource, value.getRawValue());
    }

    private static Document unwrapPlainMap(MGDataSource dataSource, Map<String, Object> value) {
        Document dbObject = new Document();
        if (value != null) {
            for (Map.Entry<String, Object> me : value.entrySet()) {
                dbObject.append(me.getKey(), MGUtils.unwrapMongoValue(dataSource, me.getKey(), me.getValue()));
            }
        }
        return dbObject;
    }

    private static BasicDBList unwrapMongoList(MGDataSource dataSource, MGListValue value) {
        BasicDBList dbList = new BasicDBList();
        if (value.getRawValue() != null) {
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                dbList.add(MGUtils.unwrapMongoValue(dataSource, null, item));
            }
        }
        return dbList;
    }

    public static String[] extractAuthInfo(String tokens) {
        String[] authTokens = tokens.split("\\|");
        try {
            return new String[]{authTokens[0], authTokens[1], SimpleStringEncrypter.INSTANCE.decrypt(authTokens[2])};
        }
        catch (EncryptionException encryptionException) {
            return new String[]{authTokens[0], authTokens[1], authTokens[2]};
        }
    }

    @NotNull
    public static Object cloneObject(Object object) {
        if (object instanceof BasicDBObject) {
            BasicDBObject basicDBObject = (BasicDBObject)object;
            return basicDBObject.copy();
        }
        if (object instanceof BasicDBList) {
            BasicDBList basicDBList = (BasicDBList)object;
            return basicDBList.copy();
        }
        if (object instanceof DBObject) {
            return object;
        }
        if (object instanceof Document) {
            Document document = (Document)object;
            return new Document((Map)document);
        }
        throw new IllegalArgumentException("Can't copy object [" + String.valueOf(object) + "]");
    }

    @Nullable
    public static String[] getHostnamesFromURL(@NotNull String url) {
        int optsPos;
        if (!MGUtils.isValidURL(url)) {
            return null;
        }
        String hostnames = url.substring(url.indexOf("://") + 3);
        int userPos = hostnames.indexOf(64);
        if (userPos != -1) {
            hostnames = hostnames.substring(userPos + 1);
        }
        if ((optsPos = hostnames.indexOf(47)) != -1) {
            hostnames = hostnames.substring(0, optsPos);
        }
        return CommonUtils.split((String)hostnames, (String)",");
    }

    @Nullable
    public static String getDatabaseFromURL(@NotNull String url) {
        if (!MGUtils.isValidURL(url)) {
            return null;
        }
        int start = url.indexOf(47, url.indexOf("://") + 3);
        int end = url.indexOf(63, start + 1);
        if (start >= 0 && end > start) {
            return url.substring(start + 1, end);
        }
        if (start >= 0) {
            return url.substring(start + 1);
        }
        return null;
    }

    public static boolean isValidURL(String url) {
        return !CommonUtils.isEmpty((String)url) && !url.startsWith("mongo://");
    }

    public static boolean isCommandResultOk(Document commandResult) {
        return commandResult.get((Object)"ok") != null;
    }

    public static String getCommandResultError(Document commandResult) {
        return (String)commandResult.get((Object)"errorMessage");
    }

    @Nullable
    public static MongoCredential getMongoCredential(MGDataSource dataSource, DBPConnectionConfiguration connectionInfo) {
        String authString;
        MongoCredential credential = null;
        String mechanism = connectionInfo.getProviderProperty("authMechanism");
        if (mechanism == null && (mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@")) == null) {
            mechanism = dataSource.getDefaultAuthMechanism();
        }
        String userName = null;
        String userPassword = null;
        String userDB = connectionInfo.getProviderProperty("authSource");
        if (CommonUtils.isEmpty((String)userDB)) {
            userDB = connectionInfo.getProviderProperty("@dbeaver-auth-source@");
        }
        if (CommonUtils.isEmpty((String)userDB)) {
            userDB = CommonUtils.notEmpty((String)connectionInfo.getDatabaseName());
        }
        if ((authString = connectionInfo.getProviderProperty("@dbeaver-auth@0")) != null) {
            String[] authTokens = MGUtils.extractAuthInfo(authString);
            userName = authTokens[0];
            userDB = authTokens[1];
            userPassword = authTokens[2];
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            userName = connectionInfo.getUserName();
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
            userPassword = connectionInfo.getUserPassword();
        }
        if (!CommonUtils.isEmpty((String)userName) && !"NONE".equals(mechanism)) {
            if (mechanism.equals(MongoCredential.PLAIN_MECHANISM)) {
                credential = MongoCredential.createPlainCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
            } else if (mechanism.equals(MongoCredential.GSSAPI_MECHANISM)) {
                credential = MongoCredential.createGSSAPICredential((String)userName);
            } else if (mechanism.equals(MongoCredential.SCRAM_SHA_1_MECHANISM) || mechanism.equals("MONGODB-CR")) {
                credential = MongoCredential.createScramSha1Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
            } else if (mechanism.equals(MongoCredential.SCRAM_SHA_256_MECHANISM)) {
                credential = MongoCredential.createScramSha256Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
            } else if (mechanism.equals(MongoCredential.MONGODB_X509_MECHANISM)) {
                credential = MongoCredential.createMongoX509Credential((String)userName);
            }
        }
        return credential;
    }

    @NotNull
    public static String transformURL(MongoCredential credential, String url) {
        int userPos = ((String)url).indexOf(64);
        if (userPos == -1 && (userPos = ((String)url).indexOf("://")) != -1) {
            userPos += 3;
        }
        if (userPos != -1 && credential != null) {
            Object userPassPart = credential.getUserName();
            if (credential.getPassword() != null) {
                userPassPart = (String)userPassPart + ":" + new String(credential.getPassword());
            }
            if (((String)url).charAt(userPos) != '@') {
                userPassPart = (String)userPassPart + "@";
            }
            url = ((String)url).substring(0, userPos) + (String)userPassPart + ((String)url).substring(userPos);
        }
        if (credential != null && credential.getMechanism() != null && !((String)url).contains("authMechanism=")) {
            url = !((String)url).contains("?") ? (String)url + "?" : (String)url + "&";
            url = (String)url + "authMechanism=" + credential.getMechanism();
        }
        return url;
    }
}

