/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xlsx;

import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableSource;
import com.dbeaver.jdbc.files.xlsx.XlsxProperties;
import com.dbeaver.jdbc.files.xlsx.XlsxReaderFactory;
import com.dbeaver.jdbc.files.xlsx.XlsxTableProperties;
import com.dbeaver.jdbc.files.xlsx.XlsxTableReader;
import java.io.IOException;
import java.nio.file.Path;
import org.jkiss.code.NotNull;

class XlsxTableReaderFactory
implements FFTableReaderFactory<Object, XlsxTableProperties> {
    @NotNull
    private final XlsxProperties properties;
    @NotNull
    private final XlsxReaderFactory readerFactory;

    XlsxTableReaderFactory(@NotNull XlsxProperties properties, @NotNull XlsxReaderFactory readerFactory) {
        this.properties = properties;
        this.readerFactory = readerFactory;
    }

    @NotNull
    public FFTableReader<Object> createReader(@NotNull FFTable<Object, XlsxTableProperties> table) throws IOException {
        FFTableSource tableSource = table.tableSource();
        Path xlsxPath = (Path)tableSource.dataFiles().get(0);
        return new XlsxTableReader(this.readerFactory.createReader(xlsxPath, this.properties), this.properties, table);
    }
}

