/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xlsx;

import com.dbeaver.jdbc.files.FFFileReaderFactory;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import com.dbeaver.jdbc.files.xlsx.XlsxProperties;
import com.dbeaver.jdbc.files.xlsx.XlsxReader;
import com.github.pjfanning.xlsx.StreamingReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.jkiss.code.NotNull;

class XlsxReaderFactory
implements FFFileReaderFactory<XlsxReader, XlsxProperties> {
    XlsxReaderFactory() {
    }

    @NotNull
    public XlsxReader createReader(@NotNull Path path, @NotNull XlsxProperties properties) throws IOException {
        String extension;
        switch (extension = FFIOUtils.getFileExtension((Path)path)) {
            case "xlsx": {
                return this.createXlsxReader(path, properties);
            }
            case "xls": {
                return this.createXlsReader(path, properties);
            }
        }
        throw new IOException("Unsupported file format: " + extension);
    }

    private XlsxReader createXlsxReader(@NotNull Path path, @NotNull XlsxProperties properties) throws IOException {
        Workbook workbook = StreamingReader.builder().rowCacheSize(200).bufferSize(10000).open(Files.newInputStream(path, new OpenOption[0]));
        return new XlsxReader(workbook, new DataFormatter(), null);
    }

    private XlsxReader createXlsReader(@NotNull Path path, @NotNull XlsxProperties properties) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(Files.newInputStream(path, new OpenOption[0]), true);
        return new XlsxReader((Workbook)workbook, new DataFormatter(), (FormulaEvaluator)workbook.getCreationHelper().createFormulaEvaluator());
    }
}

