/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.pref;

import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.model.tableau.auth.TBAuthType;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class TableauProfileEditDialog
extends BaseDialog {
    @NotNull
    private final TBAuthProfile profile;
    private Composite authTypeStackComp;
    private TBAuthType currentAuthType;
    private String profileName;
    private String siteURL;
    private String siteId;
    private String userName;
    private String userPassword;
    private String tokenName;
    private String tokenValue;
    private boolean trustServerCertificate;

    public TableauProfileEditDialog(@NotNull Shell shell, @Nullable TBAuthProfile profile) {
        super(shell, profile != null ? "Edit Tableau profile" : "Create new Tableau profile", null);
        this.profile = profile == null ? new TBAuthProfile() : profile;
        this.profileName = this.profile.getName();
        this.siteId = this.profile.getSiteId();
        this.siteURL = this.profile.getSiteURL();
        this.trustServerCertificate = this.profile.isTrustServerCertificate();
        this.currentAuthType = this.profile.getAuthType();
        this.userName = this.profile.getUserName();
        this.userPassword = this.profile.getUserPassword();
        this.tokenName = this.profile.getUserTokenName();
        this.tokenValue = this.profile.getUserTokenValue();
        this.setShellStyle(67696);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group settings = UIUtils.createControlGroup((Composite)composite, (String)"Settings", (int)2, (int)768, (int)-1);
        UIUtils.createLabelText((Composite)settings, (String)"Profile name", (String)this.profile.getName(), (int)2048).addModifyListener(e -> {
            this.profileName = ((Text)e.widget).getText();
            this.updateCompletion();
        });
        UIUtils.createLabelText((Composite)settings, (String)"Site URL", (String)this.profile.getSiteURL(), (int)2048).addModifyListener(e -> {
            this.siteURL = ((Text)e.widget).getText();
            this.updateCompletion();
        });
        UIUtils.createLabelText((Composite)settings, (String)"Site ID", (String)this.profile.getSiteId(), (int)2048).addModifyListener(e -> {
            this.siteId = ((Text)e.widget).getText();
            this.updateCompletion();
        });
        Button trustServerCertificateBtn = UIUtils.createCheckbox((Composite)settings, (String)"Trust self-signed certificate", (String)"Do not validate server certificate. Attention: do not use it with production servers", (boolean)this.trustServerCertificate, (int)2);
        trustServerCertificateBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            boolean bl = this.trustServerCertificate = trustServerCertificateBtn.getSelection();
        }));
        UIUtils.createInfoLabel((Composite)settings, (String)"Tableau server configuration. Site ID is required for Tableau Cloud.", (int)768, (int)2);
        this.currentAuthType = this.profile.getAuthType();
        Group authGroup = UIUtils.createControlGroup((Composite)composite, (String)"Authentication", (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)authGroup, (String)"Type");
        Composite authTypeGroup = UIUtils.createComposite((Composite)authGroup, (int)2);
        SelectionListener authTypeListener = SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            this.currentAuthType = (TBAuthType)selectionEvent.widget.getData();
            this.updateAuthType();
            this.updateCompletion();
            UIUtils.resizeShell((Shell)this.getShell());
        });
        Button radioUserPassword = UIUtils.createRadioButton((Composite)authTypeGroup, (String)"User name/password", (Object)TBAuthType.USER_PASSWORD, (SelectionListener)authTypeListener);
        Button radioPersonalToken = UIUtils.createRadioButton((Composite)authTypeGroup, (String)"Personal access token", (Object)TBAuthType.USER_TOKEN, (SelectionListener)authTypeListener);
        switch (this.currentAuthType) {
            case USER_PASSWORD: {
                radioUserPassword.setSelection(true);
                break;
            }
            case USER_TOKEN: {
                radioPersonalToken.setSelection(true);
            }
        }
        this.authTypeStackComp = new Composite((Composite)authGroup, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.authTypeStackComp.setLayoutData((Object)gd);
        StackLayout stackLayout = new StackLayout();
        this.authTypeStackComp.setLayout((Layout)stackLayout);
        Composite userPasswordPanel = UIUtils.createComposite((Composite)this.authTypeStackComp, (int)2);
        UIUtils.createLabelText((Composite)userPasswordPanel, (String)"User name", (String)this.profile.getUserName(), (int)2048, (Object)new GridData(768)).addModifyListener(e -> {
            String string = this.userName = ((Text)e.widget).getText();
        });
        UIUtils.createLabelText((Composite)userPasswordPanel, (String)"User password", (String)this.profile.getUserPassword(), (int)0x400000, (Object)new GridData(768)).addModifyListener(e -> {
            String string = this.userPassword = ((Text)e.widget).getText();
        });
        Composite personalTokenPanel = UIUtils.createComposite((Composite)this.authTypeStackComp, (int)2);
        UIUtils.createLabelText((Composite)personalTokenPanel, (String)"Token name", (String)this.profile.getUserName(), (int)2048, (Object)new GridData(768)).addModifyListener(e -> {
            String string = this.tokenName = ((Text)e.widget).getText();
        });
        UIUtils.createLabelText((Composite)personalTokenPanel, (String)"Token value", (String)this.profile.getUserPassword(), (int)2048, (Object)new GridData(768)).addModifyListener(e -> {
            String string = this.tokenValue = ((Text)e.widget).getText();
        });
        this.updateAuthType();
        return composite;
    }

    private void updateAuthType() {
        StackLayout stackLayout = (StackLayout)this.authTypeStackComp.getLayout();
        stackLayout.topControl = this.authTypeStackComp.getChildren()[this.currentAuthType.ordinal()];
        this.authTypeStackComp.layout();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 11, "Test ...", false);
        super.createButtonsForButtonBar(parent);
        this.updateCompletion();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 11) {
            this.testConnection();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.fillProfileFromUI(this.profile);
        super.okPressed();
    }

    private void fillProfileFromUI(TBAuthProfile profile) {
        profile.setName(this.profileName);
        profile.setSiteId(this.siteId);
        profile.setSiteURL(this.siteURL);
        profile.setTrustServerCertificate(this.trustServerCertificate);
        profile.setAuthType(this.currentAuthType);
        profile.setUserName(this.userName);
        profile.setUserPassword(this.userPassword);
        profile.setUserTokenName(this.tokenName);
        profile.setUserTokenValue(this.tokenValue);
    }

    private void testConnection() {
        TBAuthProfile testProfile = new TBAuthProfile();
        this.fillProfileFromUI(testProfile);
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    String serverInfo = testProfile.testConnection(monitor);
                    DBWorkbench.getPlatformUI().showMessageBox("Connection succeeded", "Connected to Tableau server '" + serverInfo + "'", false);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Auth failed", "Tableau authentication failed", e.getTargetException());
        }
    }

    @NotNull
    public TBAuthProfile getValue() {
        return this.profile;
    }

    private void updateCompletion() {
        boolean isValid = !CommonUtils.isEmptyTrimmed((String)this.profileName) && this.currentAuthType != null && !CommonUtils.isEmptyTrimmed((String)this.siteURL);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(isValid);
            this.getButton(11).setEnabled(isValid);
        }
    }
}

