/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.CreateMode;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ServerPropertiesForRestore
extends ServerPropertiesForCreate {
    private CreateMode createMode = CreateMode.POINT_IN_TIME_RESTORE;
    private String sourceServerId;
    private OffsetDateTime restorePointInTime;
    private static final ClientLogger LOGGER = new ClientLogger(ServerPropertiesForRestore.class);

    @Override
    public CreateMode createMode() {
        return this.createMode;
    }

    public String sourceServerId() {
        return this.sourceServerId;
    }

    public ServerPropertiesForRestore withSourceServerId(String sourceServerId) {
        this.sourceServerId = sourceServerId;
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public ServerPropertiesForRestore withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    @Override
    public ServerPropertiesForRestore withVersion(ServerVersion version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public ServerPropertiesForRestore withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        super.withSslEnforcement(sslEnforcement);
        return this;
    }

    @Override
    public ServerPropertiesForRestore withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        super.withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    @Override
    public ServerPropertiesForRestore withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        super.withInfrastructureEncryption(infrastructureEncryption);
        return this;
    }

    @Override
    public ServerPropertiesForRestore withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ServerPropertiesForRestore withStorageProfile(StorageProfile storageProfile) {
        super.withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public void validate() {
        if (this.sourceServerId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceServerId in model ServerPropertiesForRestore"));
        }
        if (this.restorePointInTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property restorePointInTime in model ServerPropertiesForRestore"));
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version() == null ? null : this.version().toString());
        jsonWriter.writeStringField("sslEnforcement", this.sslEnforcement() == null ? null : this.sslEnforcement().toString());
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion() == null ? null : this.minimalTlsVersion().toString());
        jsonWriter.writeStringField("infrastructureEncryption", this.infrastructureEncryption() == null ? null : this.infrastructureEncryption().toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile());
        jsonWriter.writeStringField("sourceServerId", this.sourceServerId);
        jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restorePointInTime));
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServerPropertiesForRestore fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForRestore)jsonReader.readObject(reader -> {
            ServerPropertiesForRestore deserializedServerPropertiesForRestore = new ServerPropertiesForRestore();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.withVersion(ServerVersion.fromString(reader.getString()));
                    continue;
                }
                if ("sslEnforcement".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.withSslEnforcement(SslEnforcementEnum.fromString(reader.getString()));
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.withMinimalTlsVersion(MinimalTlsVersionEnum.fromString(reader.getString()));
                    continue;
                }
                if ("infrastructureEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.withInfrastructureEncryption(InfrastructureEncryption.fromString(reader.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.withPublicNetworkAccess(PublicNetworkAccessEnum.fromString(reader.getString()));
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.withStorageProfile(StorageProfile.fromJson(reader));
                    continue;
                }
                if ("sourceServerId".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.sourceServerId = reader.getString();
                    continue;
                }
                if ("restorePointInTime".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.restorePointInTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedServerPropertiesForRestore.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPropertiesForRestore;
        });
    }
}

