/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresql.fluent.ServerParametersClient;
import com.azure.resourcemanager.postgresql.fluent.models.ConfigurationListResultInner;
import com.azure.resourcemanager.postgresql.implementation.PostgreSqlManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServerParametersClientImpl
implements ServerParametersClient {
    private final ServerParametersService service;
    private final PostgreSqlManagementClientImpl client;

    ServerParametersClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (ServerParametersService)RestProxy.create(ServerParametersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listUpdateConfigurationsWithResponseAsync(String resourceGroupName, String serverName, ConfigurationListResultInner value) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.validate();
        String apiVersion = "2017-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listUpdateConfigurations(this.client.getEndpoint(), "2017-12-01", this.client.getSubscriptionId(), resourceGroupName, serverName, value, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listUpdateConfigurationsWithResponseAsync(String resourceGroupName, String serverName, ConfigurationListResultInner value, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.validate();
        String apiVersion = "2017-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listUpdateConfigurations(this.client.getEndpoint(), "2017-12-01", this.client.getSubscriptionId(), resourceGroupName, serverName, value, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConfigurationListResultInner>, ConfigurationListResultInner> beginListUpdateConfigurationsAsync(String resourceGroupName, String serverName, ConfigurationListResultInner value) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.listUpdateConfigurationsWithResponseAsync(resourceGroupName, serverName, value);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationListResultInner.class), (Type)((Object)ConfigurationListResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConfigurationListResultInner>, ConfigurationListResultInner> beginListUpdateConfigurationsAsync(String resourceGroupName, String serverName, ConfigurationListResultInner value, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.listUpdateConfigurationsWithResponseAsync(resourceGroupName, serverName, value, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationListResultInner.class), (Type)((Object)ConfigurationListResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationListResultInner>, ConfigurationListResultInner> beginListUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value) {
        return this.beginListUpdateConfigurationsAsync(resourceGroupName, serverName, value).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationListResultInner>, ConfigurationListResultInner> beginListUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value, Context context) {
        return this.beginListUpdateConfigurationsAsync(resourceGroupName, serverName, value, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationListResultInner> listUpdateConfigurationsAsync(String resourceGroupName, String serverName, ConfigurationListResultInner value) {
        return this.beginListUpdateConfigurationsAsync(resourceGroupName, serverName, value).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationListResultInner> listUpdateConfigurationsAsync(String resourceGroupName, String serverName, ConfigurationListResultInner value, Context context) {
        return this.beginListUpdateConfigurationsAsync(resourceGroupName, serverName, value, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationListResultInner listUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value) {
        return (ConfigurationListResultInner)this.listUpdateConfigurationsAsync(resourceGroupName, serverName, value).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationListResultInner listUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value, Context context) {
        return (ConfigurationListResultInner)this.listUpdateConfigurationsAsync(resourceGroupName, serverName, value, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    public static interface ServerParametersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/updateConfigurations")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> listUpdateConfigurations(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") ConfigurationListResultInner var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

