/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.ServerKeysClient;
import com.azure.resourcemanager.postgresql.fluent.models.ServerKeyInner;
import com.azure.resourcemanager.postgresql.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresql.implementation.ServerKeyImpl;
import com.azure.resourcemanager.postgresql.models.ServerKey;
import com.azure.resourcemanager.postgresql.models.ServerKeys;

public final class ServerKeysImpl
implements ServerKeys {
    private static final ClientLogger LOGGER = new ClientLogger(ServerKeysImpl.class);
    private final ServerKeysClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ServerKeysImpl(ServerKeysClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ServerKey> list(String resourceGroupName, String serverName) {
        PagedIterable<ServerKeyInner> inner = this.serviceClient().list(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerKeyImpl((ServerKeyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServerKey> list(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerKeyInner> inner = this.serviceClient().list(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerKeyImpl((ServerKeyInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ServerKey> getWithResponse(String resourceGroupName, String serverName, String keyName, Context context) {
        Response<ServerKeyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, keyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerKeyImpl((ServerKeyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ServerKey get(String resourceGroupName, String serverName, String keyName) {
        ServerKeyInner inner = this.serviceClient().get(resourceGroupName, serverName, keyName);
        if (inner != null) {
            return new ServerKeyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String serverName, String keyName, String resourceGroupName) {
        this.serviceClient().delete(serverName, keyName, resourceGroupName);
    }

    @Override
    public void delete(String serverName, String keyName, String resourceGroupName, Context context) {
        this.serviceClient().delete(serverName, keyName, resourceGroupName, context);
    }

    @Override
    public ServerKey getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = ResourceManagerUtils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        return (ServerKey)this.getWithResponse(resourceGroupName, serverName, keyName, Context.NONE).getValue();
    }

    @Override
    public Response<ServerKey> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = ResourceManagerUtils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, keyName, context);
    }

    @Override
    public void deleteById(String id) {
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = ResourceManagerUtils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        this.delete(serverName, keyName, resourceGroupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = ResourceManagerUtils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        this.delete(serverName, keyName, resourceGroupName, context);
    }

    private ServerKeysClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerKeyImpl define(String name) {
        return new ServerKeyImpl(name, this.manager());
    }
}

