/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.LocationBasedPerformanceTiersClient;
import com.azure.resourcemanager.postgresql.fluent.models.PerformanceTierPropertiesInner;
import com.azure.resourcemanager.postgresql.implementation.PerformanceTierPropertiesImpl;
import com.azure.resourcemanager.postgresql.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresql.models.LocationBasedPerformanceTiers;
import com.azure.resourcemanager.postgresql.models.PerformanceTierProperties;

public final class LocationBasedPerformanceTiersImpl
implements LocationBasedPerformanceTiers {
    private static final ClientLogger LOGGER = new ClientLogger(LocationBasedPerformanceTiersImpl.class);
    private final LocationBasedPerformanceTiersClient innerClient;
    private final PostgreSqlManager serviceManager;

    public LocationBasedPerformanceTiersImpl(LocationBasedPerformanceTiersClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String locationName) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(locationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String locationName, Context context) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(locationName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    private LocationBasedPerformanceTiersClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

