/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.CheckNameAvailabilitiesClient;
import com.azure.resourcemanager.postgresql.fluent.models.NameAvailabilityInner;
import com.azure.resourcemanager.postgresql.implementation.NameAvailabilityImpl;
import com.azure.resourcemanager.postgresql.models.CheckNameAvailabilities;
import com.azure.resourcemanager.postgresql.models.NameAvailability;
import com.azure.resourcemanager.postgresql.models.NameAvailabilityRequest;

public final class CheckNameAvailabilitiesImpl
implements CheckNameAvailabilities {
    private static final ClientLogger LOGGER = new ClientLogger(CheckNameAvailabilitiesImpl.class);
    private final CheckNameAvailabilitiesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public CheckNameAvailabilitiesImpl(CheckNameAvailabilitiesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NameAvailability> executeWithResponse(NameAvailabilityRequest nameAvailabilityRequest, Context context) {
        Response<NameAvailabilityInner> inner = this.serviceClient().executeWithResponse(nameAvailabilityRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NameAvailabilityImpl((NameAvailabilityInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NameAvailability execute(NameAvailabilityRequest nameAvailabilityRequest) {
        NameAvailabilityInner inner = this.serviceClient().execute(nameAvailabilityRequest);
        if (inner != null) {
            return new NameAvailabilityImpl(inner, this.manager());
        }
        return null;
    }

    private CheckNameAvailabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

