/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.ServerKeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ServerKeyProperties
implements JsonSerializable<ServerKeyProperties> {
    private ServerKeyType serverKeyType;
    private String uri;
    private OffsetDateTime creationDate;
    private static final ClientLogger LOGGER = new ClientLogger(ServerKeyProperties.class);

    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    public ServerKeyProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ServerKeyProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public void validate() {
        if (this.serverKeyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverKeyType in model ServerKeyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverKeyType", this.serverKeyType == null ? null : this.serverKeyType.toString());
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    public static ServerKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerKeyProperties)jsonReader.readObject(reader -> {
            ServerKeyProperties deserializedServerKeyProperties = new ServerKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverKeyType".equals(fieldName)) {
                    deserializedServerKeyProperties.serverKeyType = ServerKeyType.fromString(reader.getString());
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedServerKeyProperties.uri = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedServerKeyProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerKeyProperties;
        });
    }
}

