/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class LogFileProperties
implements JsonSerializable<LogFileProperties> {
    private Long sizeInKB;
    private OffsetDateTime createdTime;
    private OffsetDateTime lastModifiedTime;
    private String type;
    private String url;

    public Long sizeInKB() {
        return this.sizeInKB;
    }

    public LogFileProperties withSizeInKB(Long sizeInKB) {
        this.sizeInKB = sizeInKB;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String type() {
        return this.type;
    }

    public LogFileProperties withType(String type) {
        this.type = type;
        return this;
    }

    public String url() {
        return this.url;
    }

    public LogFileProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("sizeInKB", (Number)this.sizeInKB);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    public static LogFileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LogFileProperties)jsonReader.readObject(reader -> {
            LogFileProperties deserializedLogFileProperties = new LogFileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sizeInKB".equals(fieldName)) {
                    deserializedLogFileProperties.sizeInKB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedLogFileProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedLogFileProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLogFileProperties.type = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedLogFileProperties.url = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogFileProperties;
        });
    }
}

