/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.fluent.models.LogFileProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class LogFileInner
extends ProxyResource {
    private LogFileProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private LogFileProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Long sizeInKB() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInKB();
    }

    public LogFileInner withSizeInKB(Long sizeInKB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withSizeInKB(sizeInKB);
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public LogFileInner withTypePropertiesType(String type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public String url() {
        return this.innerProperties() == null ? null : this.innerProperties().url();
    }

    public LogFileInner withUrl(String url) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withUrl(url);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static LogFileInner fromJson(JsonReader jsonReader) throws IOException {
        return (LogFileInner)((Object)jsonReader.readObject(reader -> {
            LogFileInner deserializedLogFileInner = new LogFileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLogFileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLogFileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLogFileInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLogFileInner.innerProperties = LogFileProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogFileInner;
        }));
    }
}

