/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.fluent.PostgreSqlManagementClient;
import com.azure.resourcemanager.postgresql.implementation.CheckNameAvailabilitiesImpl;
import com.azure.resourcemanager.postgresql.implementation.ConfigurationsImpl;
import com.azure.resourcemanager.postgresql.implementation.DatabasesImpl;
import com.azure.resourcemanager.postgresql.implementation.FirewallRulesImpl;
import com.azure.resourcemanager.postgresql.implementation.LocationBasedPerformanceTiersImpl;
import com.azure.resourcemanager.postgresql.implementation.LogFilesImpl;
import com.azure.resourcemanager.postgresql.implementation.OperationsImpl;
import com.azure.resourcemanager.postgresql.implementation.PostgreSqlManagementClientBuilder;
import com.azure.resourcemanager.postgresql.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.postgresql.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.postgresql.implementation.RecoverableServersImpl;
import com.azure.resourcemanager.postgresql.implementation.ReplicasImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerAdministratorsImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerBasedPerformanceTiersImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerKeysImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerParametersImpl;
import com.azure.resourcemanager.postgresql.implementation.ServerSecurityAlertPoliciesImpl;
import com.azure.resourcemanager.postgresql.implementation.ServersImpl;
import com.azure.resourcemanager.postgresql.implementation.VirtualNetworkRulesImpl;
import com.azure.resourcemanager.postgresql.models.CheckNameAvailabilities;
import com.azure.resourcemanager.postgresql.models.Configurations;
import com.azure.resourcemanager.postgresql.models.Databases;
import com.azure.resourcemanager.postgresql.models.FirewallRules;
import com.azure.resourcemanager.postgresql.models.LocationBasedPerformanceTiers;
import com.azure.resourcemanager.postgresql.models.LogFiles;
import com.azure.resourcemanager.postgresql.models.Operations;
import com.azure.resourcemanager.postgresql.models.PrivateEndpointConnections;
import com.azure.resourcemanager.postgresql.models.PrivateLinkResources;
import com.azure.resourcemanager.postgresql.models.RecoverableServers;
import com.azure.resourcemanager.postgresql.models.Replicas;
import com.azure.resourcemanager.postgresql.models.ServerAdministrators;
import com.azure.resourcemanager.postgresql.models.ServerBasedPerformanceTiers;
import com.azure.resourcemanager.postgresql.models.ServerKeys;
import com.azure.resourcemanager.postgresql.models.ServerParameters;
import com.azure.resourcemanager.postgresql.models.ServerSecurityAlertPolicies;
import com.azure.resourcemanager.postgresql.models.Servers;
import com.azure.resourcemanager.postgresql.models.VirtualNetworkRules;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class PostgreSqlManager {
    private Servers servers;
    private Replicas replicas;
    private FirewallRules firewallRules;
    private VirtualNetworkRules virtualNetworkRules;
    private Databases databases;
    private Configurations configurations;
    private ServerParameters serverParameters;
    private LogFiles logFiles;
    private ServerAdministrators serverAdministrators;
    private RecoverableServers recoverableServers;
    private ServerBasedPerformanceTiers serverBasedPerformanceTiers;
    private LocationBasedPerformanceTiers locationBasedPerformanceTiers;
    private CheckNameAvailabilities checkNameAvailabilities;
    private Operations operations;
    private ServerSecurityAlertPolicies serverSecurityAlertPolicies;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private ServerKeys serverKeys;
    private final PostgreSqlManagementClient clientObject;

    private PostgreSqlManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new PostgreSqlManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static PostgreSqlManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return PostgreSqlManager.configure().authenticate(credential, profile);
    }

    public static PostgreSqlManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new PostgreSqlManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Servers servers() {
        if (this.servers == null) {
            this.servers = new ServersImpl(this.clientObject.getServers(), this);
        }
        return this.servers;
    }

    public Replicas replicas() {
        if (this.replicas == null) {
            this.replicas = new ReplicasImpl(this.clientObject.getReplicas(), this);
        }
        return this.replicas;
    }

    public FirewallRules firewallRules() {
        if (this.firewallRules == null) {
            this.firewallRules = new FirewallRulesImpl(this.clientObject.getFirewallRules(), this);
        }
        return this.firewallRules;
    }

    public VirtualNetworkRules virtualNetworkRules() {
        if (this.virtualNetworkRules == null) {
            this.virtualNetworkRules = new VirtualNetworkRulesImpl(this.clientObject.getVirtualNetworkRules(), this);
        }
        return this.virtualNetworkRules;
    }

    public Databases databases() {
        if (this.databases == null) {
            this.databases = new DatabasesImpl(this.clientObject.getDatabases(), this);
        }
        return this.databases;
    }

    public Configurations configurations() {
        if (this.configurations == null) {
            this.configurations = new ConfigurationsImpl(this.clientObject.getConfigurations(), this);
        }
        return this.configurations;
    }

    public ServerParameters serverParameters() {
        if (this.serverParameters == null) {
            this.serverParameters = new ServerParametersImpl(this.clientObject.getServerParameters(), this);
        }
        return this.serverParameters;
    }

    public LogFiles logFiles() {
        if (this.logFiles == null) {
            this.logFiles = new LogFilesImpl(this.clientObject.getLogFiles(), this);
        }
        return this.logFiles;
    }

    public ServerAdministrators serverAdministrators() {
        if (this.serverAdministrators == null) {
            this.serverAdministrators = new ServerAdministratorsImpl(this.clientObject.getServerAdministrators(), this);
        }
        return this.serverAdministrators;
    }

    public RecoverableServers recoverableServers() {
        if (this.recoverableServers == null) {
            this.recoverableServers = new RecoverableServersImpl(this.clientObject.getRecoverableServers(), this);
        }
        return this.recoverableServers;
    }

    public ServerBasedPerformanceTiers serverBasedPerformanceTiers() {
        if (this.serverBasedPerformanceTiers == null) {
            this.serverBasedPerformanceTiers = new ServerBasedPerformanceTiersImpl(this.clientObject.getServerBasedPerformanceTiers(), this);
        }
        return this.serverBasedPerformanceTiers;
    }

    public LocationBasedPerformanceTiers locationBasedPerformanceTiers() {
        if (this.locationBasedPerformanceTiers == null) {
            this.locationBasedPerformanceTiers = new LocationBasedPerformanceTiersImpl(this.clientObject.getLocationBasedPerformanceTiers(), this);
        }
        return this.locationBasedPerformanceTiers;
    }

    public CheckNameAvailabilities checkNameAvailabilities() {
        if (this.checkNameAvailabilities == null) {
            this.checkNameAvailabilities = new CheckNameAvailabilitiesImpl(this.clientObject.getCheckNameAvailabilities(), this);
        }
        return this.checkNameAvailabilities;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public ServerSecurityAlertPolicies serverSecurityAlertPolicies() {
        if (this.serverSecurityAlertPolicies == null) {
            this.serverSecurityAlertPolicies = new ServerSecurityAlertPoliciesImpl(this.clientObject.getServerSecurityAlertPolicies(), this);
        }
        return this.serverSecurityAlertPolicies;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public ServerKeys serverKeys() {
        if (this.serverKeys == null) {
            this.serverKeys = new ServerKeysImpl(this.clientObject.getServerKeys(), this);
        }
        return this.serverKeys;
    }

    public PostgreSqlManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public PostgreSqlManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.postgresql").append("/").append("1.1.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new PostgreSqlManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

