/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.dbeaver.db.cassandra.CasUtils;
import com.dbeaver.db.cassandra.data.CasCollectionValue;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasDataType;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasSetValue
extends CasCollectionValue
implements DBDValueCloneable {
    private final DataType elementType;
    private List<Object> contents;
    @NotNull
    private SetType type;
    @NotNull
    private CasDataType componentType;
    private boolean modified;

    public CasSetValue(@NotNull CasExecutionContext executionContext, String keyspace, Collection<?> contents, @NotNull SetType type) throws DBCException {
        super(executionContext, keyspace);
        if (contents != null) {
            this.contents = new ArrayList<Object>(contents.size());
            for (Object object : contents) {
                this.contents.add(CasUtils.wrapValue((DBCExecutionContext)executionContext, keyspace, object));
            }
        }
        this.type = type;
        this.elementType = type.getElementType();
        this.componentType = (CasDataType)((CasDataSource)executionContext.getDataSource()).getLocalDataType(type.getElementType().getProtocolCode());
    }

    @NotNull
    public Class<? super Object> getElementClass() {
        return CodecRegistry.DEFAULT.codecFor(this.getElementType()).getJavaType().getRawType();
    }

    public CasSetValue(@NotNull CasSetValue copy) throws DBCException {
        this(copy.executionContext, copy.keyspace, copy.contents, copy.type);
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.componentType;
    }

    @NotNull
    public SetType getType() {
        return this.type;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.executionContext.getDataSource(), (DBSTypedObject)this.componentType);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new CasSetValue(this.executionContext, this.keyspace, this.contents, this.type);
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        DBDValueHandler cvh = this.getComponentValueHandler();
        StringBuilder str = new StringBuilder(this.contents.size() * 32);
        str.append("{");
        int i = 0;
        while (i < this.contents.size()) {
            Object item = this.contents.get(i);
            if (i > 0) {
                str.append(',');
            }
            String itemString = cvh.getValueDisplayString((DBSTypedObject)this.componentType, item, DBDDisplayFormat.NATIVE);
            SQLUtils.appendValue((StringBuilder)str, (DBSTypedObject)this.componentType, (Object)itemString);
            ++i;
        }
        str.append("}");
        return str.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public Object getItem(int index) {
        return this.contents.get(index);
    }

    public void setItem(int index, Object value) {
        this.contents.set(index, value);
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        if (this.contents == null) {
            this.contents = new ArrayList<Object>();
        } else {
            this.contents.clear();
        }
        Collections.addAll(this.contents, contents);
        this.modified = true;
    }

    public <VALUE_CLASS> Set<VALUE_CLASS> makeSet() {
        if (this.contents == null) {
            return null;
        }
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(this.contents.size());
        for (Object item : this.contents) {
            set.add(CasUtils.unwrapValue(item));
        }
        return set;
    }
}

