/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage;

import com.dbeaver.model.ai.RAGEmbeddingStorage;
import com.dbeaver.model.ai.rag.storage.RAGDatabase;
import com.dbeaver.model.ai.rag.storage.RAGDatabaseAdapter;
import com.dbeaver.model.ai.rag.storage.RAGDatabaseCleanupJob;
import com.dbeaver.model.ai.rag.storage.RAGDatabaseConfiguration;
import com.dbeaver.model.ai.rag.storage.pg.RAGPostgresAdapter;
import com.dbeaver.model.ai.rag.storage.sqlite.RAGSQLiteAdapter;
import java.time.Duration;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class RAGEmbeddingStorageFactory {
    public static final RAGEmbeddingStorageFactory INSTANCE = new RAGEmbeddingStorageFactory();
    private static final Map<RAGDatabaseConfiguration.DatabaseType, RAGDatabaseAdapter> ADAPTERS = Map.of(RAGDatabaseConfiguration.DatabaseType.POSTGRESQL, RAGPostgresAdapter.INSTANCE, RAGDatabaseConfiguration.DatabaseType.SQLITE, RAGSQLiteAdapter.INSTANCE);

    public RAGEmbeddingStorage createStorage(@NotNull RAGDatabaseConfiguration configuration) throws DBException {
        RAGDatabaseAdapter adapter = ADAPTERS.get((Object)configuration.getDatabaseType());
        if (adapter == null) {
            throw new DBException("Unsupported RAG database type: " + String.valueOf((Object)configuration.getDatabaseType()) + ". Supported types: " + String.valueOf(ADAPTERS.keySet()));
        }
        RAGDatabase ragDatabase = new RAGDatabase(configuration, adapter.getExtensionsInitializer());
        ragDatabase.init();
        RAGEmbeddingStorage embeddingStorage = adapter.createEmbeddingStorage(ragDatabase);
        new RAGDatabaseCleanupJob(DBWorkbench.getPlatform(), embeddingStorage).schedule(Duration.ofMinutes(1L));
        return embeddingStorage;
    }
}

