/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage;

import org.jkiss.api.CompositeObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;

public class RAGDatabaseConfiguration
implements InternalDatabaseConfig {
    public static final String DEFAULT_SCHEMA = "ai";
    public static final CompositeObjectId POSTGRESQL_DRIVER_ID = CompositeObjectId.of((String)"postgresql:postgres-jdbc");
    public static final CompositeObjectId SQLITE_DRIVER_ID = CompositeObjectId.of((String)"sqlite-ee:sqlite_ee");
    private String driver;
    private String url;
    private String schema;
    private String user;
    private String password;

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @NotNull
    public String getUrl() {
        if (this.url == null) {
            return "";
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSchema() {
        return this.schema;
    }

    public InternalDatabaseConfig.Pool getPool() {
        return new InternalDatabaseConfig.Pool(1, 1, 1, "select 1");
    }

    public boolean isBackupEnabled() {
        return false;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @NotNull
    public DatabaseType getDatabaseType() {
        if (this.driver != null) {
            if (this.driver.contains("postgres")) {
                return DatabaseType.POSTGRESQL;
            }
            if (this.driver.contains("sqlite")) {
                return DatabaseType.SQLITE;
            }
        }
        return DatabaseType.NOT_SUPPORTED;
    }

    public static enum DatabaseType {
        POSTGRESQL,
        SQLITE,
        NOT_SUPPORTED;

    }
}

