/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage;

import com.dbeaver.model.ai.rag.storage.RAGDatabaseConfiguration;
import com.dbeaver.model.ai.rag.storage.RAGDatabaseExtensionsInitializer;
import com.dbeaver.model.ai.rag.storage.RAGSchemaVersionManager;
import java.sql.Connection;
import java.sql.Driver;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.sql.db.InternalDB;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaConfig;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaVersionManager;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;

public class RAGDatabase
extends InternalDB<RAGDatabaseConfiguration> {
    private static final Log log = Log.getLog(RAGDatabase.class);
    private static final String SCHEMA_ID = "RAG";
    static final SQLSchemaConfig SQL_SCHEMA_CONFIG = new SQLSchemaConfig("RAG", "db/rag_create", "", 1, 0, (SQLSchemaVersionManager)new RAGSchemaVersionManager(), RAGDatabase.class.getClassLoader());
    private final RAGDatabaseExtensionsInitializer extensionsInitializer;

    public RAGDatabase(@NotNull RAGDatabaseConfiguration dbConfiguration, @NotNull RAGDatabaseExtensionsInitializer extensionsInitializer) {
        super("RAG DB", (InternalDatabaseConfig)dbConfiguration, List.of(SQL_SCHEMA_CONFIG));
        this.extensionsInitializer = extensionsInitializer;
    }

    public void init() throws DBException {
        log.debug((Object)"Initiate management database");
        DBPDriver driver = this.getDriver();
        LoggingProgressMonitor monitor = new LoggingProgressMonitor(log);
        driver = driver.createOriginalCopy();
        this.dataSource = this.initConnectionPool((Driver)driver.getDefaultDriverLoader().getDriverInstance((DBRProgressMonitor)monitor), driver.getFullName());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.getDatabaseConnection();){
                this.dialect = driver.getScriptDialect().createInstance();
                this.initSchema((DBRProgressMonitor)monitor, connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("Error updating management database schema", (Throwable)e);
        }
        log.debug((Object)"\tManagement database connection established");
    }

    @NotNull
    public synchronized Connection getDatabaseConnection() throws DBCException {
        Connection connection = super.getDatabaseConnection();
        try {
            this.extensionsInitializer.initializeExtensions(this.getDriver(), connection);
        }
        catch (DBException e) {
            throw new DBCException("Error initializing database extensions", (Throwable)e);
        }
        return connection;
    }

    protected void initializeSchema(@NotNull DBRProgressMonitor monitor, @Nullable Connection connection) throws Exception {
        if (connection == null) {
            throw new DBException("No database connection established");
        }
        this.createSchemaIfNotExists(connection);
        this.updateSchema(monitor, connection);
    }

    protected DataSource initConnectionPool(@NotNull Driver driverInstance, @NotNull String fullName) {
        String dbURL = ((RAGDatabaseConfiguration)this.databaseConfig).getUrl();
        log.debug((Object)("\tInitiate connection pool with management database (" + fullName + "; " + dbURL + ")"));
        DriverConnectionFactory conFactory = new DriverConnectionFactory(driverInstance, dbURL, this.getProperties());
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)conFactory, null);
        pcf.setValidationQuery(((RAGDatabaseConfiguration)this.databaseConfig).getPool().getValidationQuery());
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(((RAGDatabaseConfiguration)this.databaseConfig).getPool().getMinIdleConnections());
        config.setMaxIdle(((RAGDatabaseConfiguration)this.databaseConfig).getPool().getMaxIdleConnections());
        config.setMaxTotal(((RAGDatabaseConfiguration)this.databaseConfig).getPool().getMaxConnections());
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pcf, config);
        pcf.setPool((ObjectPool)connectionPool);
        return new PoolingDataSource((ObjectPool)connectionPool);
    }

    @NotNull
    protected Properties getProperties() {
        Properties properties = super.getProperties();
        properties.putAll(this.extensionsInitializer.getConnectionProperties(((RAGDatabaseConfiguration)this.databaseConfig).getDriver()));
        return properties;
    }

    @NotNull
    public DBPDriver getDriver() throws DBException {
        return this.getDatabaseDriver((DBPDataSourceProviderRegistry)DataSourceProviderRegistry.getInstance());
    }
}

