/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.models.SkuCapability;
import java.io.IOException;
import java.util.List;

public final class ServerVersionCapability
implements JsonSerializable<ServerVersionCapability> {
    private String name;
    private List<SkuCapability> supportedSkus;

    public String name() {
        return this.name;
    }

    public List<SkuCapability> supportedSkus() {
        return this.supportedSkus;
    }

    public void validate() {
        if (this.supportedSkus() != null) {
            this.supportedSkus().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ServerVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ServerVersionCapability)jsonReader.readObject(reader -> {
            ServerVersionCapability deserializedServerVersionCapability = new ServerVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedServerVersionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedSkus".equals(fieldName)) {
                    List supportedSkus;
                    deserializedServerVersionCapability.supportedSkus = supportedSkus = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerVersionCapability;
        });
    }
}

