/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui.ai.function;

import com.dbeaver.model.ai.AIUtilsPro;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.tools.transfer.ui.SQLPragmaExport;
import org.jkiss.utils.CommonUtils;

public class AIFunctionExportTableDataToFile
implements AIFunction {
    public static final String PARAM_TABLE = "table";
    public static final String PARAM_FORMAT = "outputFormat";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String tableName = JSONUtils.getString(parameters, (String)PARAM_TABLE);
        if (CommonUtils.isEmpty((String)tableName)) {
            throw new DBException("Table name parameter is missing");
        }
        String format = JSONUtils.getString(parameters, (String)PARAM_FORMAT);
        if (CommonUtils.isEmpty((String)format)) {
            throw new DBException("Format parameter is missing");
        }
        DBSDataContainer table = AIUtilsPro.findTableInContext((AIFunctionContext)context, (String)tableName);
        SQLPragmaExport pragmaExport = new SQLPragmaExport();
        LinkedHashMap<String, String> pragmaParameters = new LinkedHashMap<String, String>();
        pragmaParameters.put("type", format);
        DBRRunnableWithReturn callback = monitor -> pragmaExport.processPragma(context.getMonitor(), table, pragmaParameters);
        callback.runTask(context.getMonitor());
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Export table '" + tableName + "' as " + format, callback);
    }
}

