/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.api;

public enum LMLicenseType {
    STANDARD('S', "Yearly subscription", true, true),
    YEAR_UPDATE('Y', "Perpetual", false, false),
    YEAR_CORPORATE('C', "Corporate", false, false),
    ULTIMATE('U', "Ultimate", false, false),
    LIMITED('L', "Limited", true, true),
    PARTNER('P', "Technical partner", false, false),
    TRIAL('T', "Trial", true, true),
    EAP('E', "Early Access Program", false, false),
    ACADEMIC('A', "Academic", true, true),
    TEAM('M', "Yearly subscription (Team)", true, true),
    MARKETPLACE('R', "Marketplace subscription", false, false),
    CUSTOM('X', "Custom", false, false),
    PER_MACHINE('D', "Per Machine", true, true);

    private final char id;
    private final String displayName;
    private final boolean isExtendable;
    private final boolean needsEndTime;

    private LMLicenseType(char id, String displayName, boolean isExtendable, boolean needsEndTime) {
        this.id = id;
        this.displayName = displayName;
        this.isExtendable = isExtendable;
        this.needsEndTime = needsEndTime;
    }

    public byte getId() {
        return (byte)this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isExtendable() {
        return this.isExtendable;
    }

    public boolean needsEndTime() {
        return this.needsEndTime;
    }

    public static LMLicenseType valueOf(String string) {
        return Enum.valueOf(LMLicenseType.class, string);
    }
}

