/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlTime
extends SqlData
implements DbmsConst {
    private String value = null;
    private String timezone = null;
    private short dbms_type = (short)8;
    private SqlDates dates;
    private static Date now = new Date();

    public SqlTime(short s) throws SQLException {
        super(true);
        switch (s) {
            case 6: 
            case 7: 
            case 8: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        this.dates = SqlDates.getDefaultInstance();
    }

    public SqlTime(SqlDates sqlDates, short s) throws SQLException {
        super(true);
        switch (s) {
            case 6: 
            case 7: 
            case 8: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        this.dates = sqlDates;
    }

    public void set(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            if (this.dbms_type == 7) {
                if (string.length() < "HH:mm:ss".length() + "+HH:mm".length()) {
                    throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
                }
                int n = string.length() - "+HH:mm".length();
                this.timezone = string.substring(n);
                string = string.substring(0, n);
            }
            if (string.length() > "HH:mm:ss".length()) {
                string = string.substring(0, "HH:mm:ss".length());
            }
            this.setNotNull();
            this.value = string;
        }
    }

    public void set(SqlTime sqlTime) {
        if (sqlTime == null || sqlTime.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlTime.value;
            this.timezone = sqlTime.timezone;
            this.dbms_type = sqlTime.dbms_type;
        }
    }

    public String get() {
        return this.dbms_type == 7 ? this.value + this.timezone : this.value;
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            Time time;
            try {
                time = Time.valueOf(string);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setTime(time, null);
        }
    }

    @Override
    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        this.set(time, timeZone);
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        this.set(timestamp, timeZone);
    }

    private void set(Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        switch (this.dbms_type) {
            case 8: {
                this.value = this.dates.formatTime(date, true);
                break;
            }
            case 6: {
                this.value = timeZone != null ? this.dates.formatTime(date, timeZone) : this.dates.formatTime(date, false);
                break;
            }
            case 7: {
                this.value = timeZone != null ? this.dates.formatTime(date, timeZone) : this.dates.formatTime(date, false);
                long l = System.currentTimeMillis();
                String string = this.timezone = timeZone != null ? this.dates.formatTZ(timeZone, l) : this.dates.formatTZ(l);
            }
        }
        if (this.value == null || this.value.length() != 8 || this.value.charAt(2) != ':' || this.value.charAt(5) != ':') {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    @Override
    public String getString() throws SQLException {
        return this.dates.formatTime((Date)this.get(null), false);
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        return this.get(timeZone);
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        return new Timestamp(this.get(timeZone).getTime());
    }

    @Override
    public Object getObject() throws SQLException {
        return this.get(null);
    }

    private Time get(TimeZone timeZone) throws SQLException {
        Time time = null;
        switch (this.dbms_type) {
            case 8: {
                if (timeZone == null) {
                    timeZone = TimeZone.getDefault();
                }
                now.setTime(System.currentTimeMillis());
                if (!timeZone.useDaylightTime() || !timeZone.inDaylightTime(now)) {
                    time = this.dates.parseTime(this.value, true);
                } else {
                    int n = timeZone.getDSTSavings() / 60000;
                    time = this.dates.parseTime(this.value, this.dates.getTZ(-n));
                }
                long l = time.getTime();
                long l2 = 86400000L;
                if (l < 0L || l >= l2) break;
                if (l + (long)timeZone.getRawOffset() < 0L) {
                    time.setTime(l + l2);
                    break;
                }
                if (l + (long)timeZone.getRawOffset() < l2) break;
                time.setTime(l - l2);
                break;
            }
            case 6: {
                time = timeZone != null ? this.dates.parseTime(this.value, timeZone) : this.dates.parseTime(this.value, false);
                break;
            }
            case 7: {
                if (timeZone == null) {
                    timeZone = TimeZone.getDefault();
                }
                now.setTime(System.currentTimeMillis());
                if (!timeZone.useDaylightTime() || !timeZone.inDaylightTime(now)) {
                    time = this.dates.parseTime(this.value, this.dates.getTZ(this.timezone));
                    break;
                }
                int n = timeZone.getDSTSavings();
                timeZone = this.dates.getTZ(this.timezone);
                time = this.dates.parseTime(this.value, this.dates.getTZ((timeZone.getRawOffset() - n) / 60000));
            }
        }
        return time;
    }
}

