/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvBlob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcBlob;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlVarByte;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;

class SqlBLoc
extends SqlLoc {
    private DrvConn conn = null;

    public SqlBLoc(DrvConn drvConn) throws SQLException {
        this.conn = drvConn;
    }

    public void set(SqlBLoc sqlBLoc) {
        if (sqlBLoc == null || sqlBLoc.isNull()) {
            this.setNull();
        } else {
            this.conn = sqlBLoc.conn;
            this.set((SqlLoc)sqlBLoc);
        }
    }

    @Override
    public void setBlob(Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull();
        } else if (blob instanceof DrvBlob) {
            this.set(((DrvBlob)blob).getLocator());
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        return new JdbcBlob(new DrvBlob(this.conn, this.value), this.conn.cnf_lob_segSize, this.conn.trace);
    }

    @Override
    public String getString() throws SQLException {
        byte[] byArray = SqlLongByte.strm2array(this.getBinaryStream());
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    @Override
    public String getString(int n) throws SQLException {
        byte[] byArray = SqlLongByte.strm2array(this.getBinaryStream(), n);
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return SqlLongByte.strm2array(this.getBinaryStream());
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return SqlLongByte.strm2array(this.getBinaryStream(), n);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        DrvBlob drvBlob = new DrvBlob(this.conn, this.value);
        InputStream inputStream = drvBlob.getBinaryStream();
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return SqlStream.getAsciiIS(this.getCharacterStream());
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return SqlStream.getUnicodeIS(this.getCharacterStream());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return SqlLongByte.byteIS2hexRdr(this.getBinaryStream());
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBlob();
    }
}

