/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlWarn;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public abstract class JdbcRslt
extends DrvObj
implements ResultSet,
DrvConst {
    protected static final int CLOSED = 0;
    protected static final int BEFORE = 1;
    protected static final int AFTER = 2;
    protected static final int ROW = 3;
    protected JdbcRSMD rsmd = null;
    protected int posStatus = 1;
    protected Row currentRow = null;
    protected int rowCount = -1;
    protected int rs_type = 1003;
    protected int rs_concur = 1007;
    protected int rs_fetch_dir = 1000;
    protected int rs_fetch_size = 0;
    protected int rs_max_rows = 0;
    protected int rs_max_len = 0;
    private boolean isNull = false;

    protected JdbcRslt(DrvConn drvConn, JdbcRSMD jdbcRSMD) throws SQLException {
        super(drvConn);
        this.rsmd = jdbcRSMD;
        this.title = this.trace.getTraceName() + "-ResultSet[" + this.inst_id + "]";
        this.tr_id = "Rslt[" + this.inst_id + "]";
    }

    protected abstract void load() throws SQLException;

    protected void load(int n, int n2, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ": scrolling not supported");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    protected void flush() throws SQLException {
    }

    protected void flush(int n) throws SQLException {
        throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
    }

    protected void finalize() throws Throwable {
        if (this.posStatus != 0) {
            try {
                this.shut();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }

    @Override
    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        this.warnings = null;
        this.isNull = false;
        try {
            if (!this.shut() && this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ": result-set already closed!");
            }
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".close(): error closing result-set");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shut() throws SQLException {
        JdbcRslt jdbcRslt = this;
        synchronized (jdbcRslt) {
            if (this.posStatus == 0) {
                return false;
            }
            this.posStatus = 0;
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ": result-set closed");
        }
        this.currentRow = null;
        return true;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".beforeFirst()");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        switch (this.posStatus) {
            case 1: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".beforeFirst: result-set at BOD");
                break;
            }
            case 2: 
            case 3: {
                this.load(1, 0, false);
                this.checkRow();
                break;
            }
            default: {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".beforeFirst: result-set closed");
                }
                throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
            }
        }
    }

    @Override
    public synchronized boolean first() throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".first()");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        switch (this.posStatus) {
            case 1: {
                if (this.rs_type == 1003) {
                    bl = this.doNext();
                    break;
                }
            }
            case 2: 
            case 3: {
                this.load(1, 1, true);
                bl = this.checkRow();
                break;
            }
            default: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".first: result-set closed");
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".first: " + bl);
        }
        return bl;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".previous()");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        switch (this.posStatus) {
            case 1: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".previous: result-set at BOD");
                break;
            }
            case 2: 
            case 3: {
                this.load(3, -1, true);
                bl = this.checkRow();
                break;
            }
            default: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".previous: result-set closed");
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".previous: " + bl);
        }
        return bl;
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".refreshRow()");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        switch (this.posStatus) {
            case 3: {
                this.load(3, 0, true);
                this.checkRow();
                break;
            }
            case 1: 
            case 2: {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + "refreshRow: not positioned on a row");
                }
                throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
            }
            default: {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".refreshRow: result-set closed");
                }
                throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
            }
        }
    }

    @Override
    public synchronized boolean next() throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".next()");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        switch (this.posStatus) {
            case 1: 
            case 3: {
                bl = this.doNext();
                break;
            }
            case 2: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".next: result-set at EOD");
                break;
            }
            default: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".next: result-set closed");
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".next: " + bl);
        }
        return bl;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".last()");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        switch (this.posStatus) {
            case 1: 
            case 2: 
            case 3: {
                if (this.rs_max_rows > 0 && (this.rowCount < 0 || this.rs_max_rows < this.rowCount)) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.tr_id + ".last: limit to max row " + this.rs_max_rows);
                    }
                    this.load(1, this.rs_max_rows, true);
                    bl = this.checkRow();
                    if (bl) break;
                    this.flush();
                    this.warnings = null;
                }
                this.load(2, -1, true);
                bl = this.checkRow();
                break;
            }
            default: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".last: result-set closed");
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".last: " + bl);
        }
        return bl;
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".afterLast()");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        switch (this.posStatus) {
            case 1: 
            case 3: {
                if (this.rs_max_rows > 0 && (this.rowCount < 0 || this.rs_max_rows < this.rowCount)) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.tr_id + ".afterLast: limit to max row = " + this.rs_max_rows);
                    }
                    this.load(1, this.rs_max_rows + 1, false);
                    this.checkRow();
                    break;
                }
                this.load(2, 0, false);
                this.checkRow();
                break;
            }
            case 2: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".afterLast: result-set at EOD");
                break;
            }
            default: {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".afterLast: result-set closed");
                }
                throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
            }
        }
    }

    @Override
    public synchronized boolean relative(int n) throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".relative( " + n + " )");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        int n2 = this.posStatus == 3 ? this.currentRow.id : -1;
        switch (this.posStatus) {
            case 1: {
                if (n <= 0) {
                    if (!this.trace.enabled(3)) break;
                    this.trace.write(this.tr_id + ".relative: result-set at BOD");
                    break;
                }
                n2 = 0;
            }
            case 3: {
                if (n == 1) {
                    bl = this.doNext();
                    break;
                }
                if (this.rs_max_rows > 0 && (this.rowCount < 0 || this.rs_max_rows > this.rowCount) && n > 0 && n2 + n > this.rs_max_rows) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.tr_id + ".relative: max row limit reached");
                    }
                    this.load(1, this.rs_max_rows + 1, false);
                    bl = this.checkRow();
                    break;
                }
                this.load(this.posStatus, n, true);
                bl = this.checkRow();
                break;
            }
            case 2: {
                if (n >= 0) {
                    if (!this.trace.enabled(3)) break;
                    this.trace.write(this.tr_id + ".relative: result-set at EOD");
                    break;
                }
                this.load(3, n, true);
                bl = this.checkRow();
                break;
            }
            default: {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".relative: result-set closed");
                }
                throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".relative: " + bl);
        }
        return bl;
    }

    @Override
    public synchronized boolean absolute(int n) throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".absolute( " + n + " )");
        }
        this.flush();
        this.warnings = null;
        this.isNull = false;
        int n2 = this.posStatus == 3 ? this.currentRow.id : -1;
        switch (this.posStatus) {
            case 1: {
                if (n == 0) {
                    if (!this.trace.enabled(3)) break;
                    this.trace.write(this.tr_id + ".absolute: result-set at BOD");
                    break;
                }
                n2 = 0;
            }
            case 3: {
                if (n > 0 && n - 1 == n2) {
                    bl = this.doNext();
                    break;
                }
            }
            case 2: {
                if (!(this.rs_max_rows <= 0 || this.rowCount >= 0 && this.rs_max_rows >= this.rowCount || n >= 0 && n <= this.rs_max_rows)) {
                    int n3;
                    if (n >= 0) {
                        if (this.trace.enabled(3)) {
                            this.trace.write(this.tr_id + ".absolute: max row limit reached");
                        }
                        this.load(1, this.rs_max_rows + 1, false);
                        bl = this.checkRow();
                        break;
                    }
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.tr_id + ".absolute: adjust offset for max row limit");
                    }
                    if (n < -this.rs_max_rows) {
                        this.load(1, 0, false);
                        bl = this.checkRow();
                        break;
                    }
                    if (this.rowCount > 0) {
                        this.load(1, this.rs_max_rows + n + 1, true);
                        bl = this.checkRow();
                        break;
                    }
                    this.load(2, n, true);
                    if (this.posStatus == 3 && this.currentRow.id > (n3 = this.rs_max_rows + n + 1)) {
                        this.flush();
                        this.warnings = null;
                        this.load(1, n3, true);
                    }
                    bl = this.checkRow();
                    break;
                }
                if (n == 0) {
                    this.load(1, 0, false);
                } else if (n > 0) {
                    this.load(1, n, true);
                } else {
                    this.load(2, n, true);
                }
                bl = this.checkRow();
                break;
            }
            default: {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".absolute: result-set closed");
                }
                throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".absolute: " + bl);
        }
        return bl;
    }

    private boolean doNext() throws SQLException {
        if (this.rs_max_rows > 0 && this.posStatus == 3 && this.currentRow.id >= this.rs_max_rows) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".doNext: max row limit reached");
            }
            if (this.rs_type == 1003) {
                try {
                    this.shut();
                }
                catch (SQLException sQLException) {}
            } else {
                this.load(1, this.rs_max_rows + 1, false);
            }
        } else {
            try {
                this.load();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".next(): error loading row");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                try {
                    this.shut();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        return this.checkRow();
    }

    private boolean checkRow() {
        boolean bl = false;
        if (this.posStatus == 3) {
            bl = true;
            if (this.rs_max_rows > 0) {
                if (this.currentRow.id == this.rs_max_rows) {
                    this.currentRow.status |= 2;
                } else if (this.currentRow.id > this.rs_max_rows) {
                    this.posStatus = 2;
                    this.currentRow = null;
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.posStatus == 0;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getStatement(): " + null);
        }
        return null;
    }

    @Override
    public int getType() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getType(): " + this.rs_type);
        }
        return this.rs_type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConcurrency(): " + this.rs_concur);
        }
        return this.rs_concur;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchDirection(): " + this.rs_fetch_dir);
        }
        return this.rs_fetch_dir;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchDirection( " + n + " )");
        }
        if (n != 1000) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchSize(): " + this.rs_fetch_size);
        }
        return this.rs_fetch_size;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchSize( " + n + " )");
        }
        if (n < 0 || this.rs_max_rows > 0 && n > this.rs_max_rows) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.rs_fetch_size = n;
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCursorName(): " + null);
        }
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMetaData(): " + this.rsmd);
        }
        if (this.posStatus == 0) {
            throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
        }
        return this.rsmd;
    }

    @Override
    public int getRow() throws SQLException {
        int n;
        int n2 = n = this.posStatus != 3 ? 0 : this.currentRow.id;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRow(): " + n);
        }
        return n;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.posStatus == 1 && this.rowCount != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isBeforeFirst(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.posStatus == 2 && this.rowCount != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isAfterLast(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean isFirst() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.posStatus == 3 && (this.currentRow.status & 1) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isFirst(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean isLast() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.posStatus == 3 && (this.currentRow.status & 2) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isLast(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.posStatus == 3 && (this.currentRow.status & 0x10) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rowInserted(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.posStatus == 3 && (this.currentRow.status & 0x20) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rowUpdated(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.posStatus == 3 && (this.currentRow.status & 0x40) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rowDeleted(): " + bl);
        }
        return bl;
    }

    @Override
    public void insertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".insertRow()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRow()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".deleteRow()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToInsertRow()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToCurrentRow()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".cancelRowUpdates() ");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNull()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBoolean()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateByte()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateShort()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateInt()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateLong()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateFloat()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDouble()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBigDecimal()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateString()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBytes()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDate()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTime()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTimestamp()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBinaryStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateAsciiStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateCharacterStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateArray()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBlob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateClob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRef()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateSQLXML()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateSQLXML()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRowId()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRowId()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNClob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNString()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateClob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNClob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBlob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateCharacterStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateCharacterStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateAsciiStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNCharacterStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNClob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateClob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBlob()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateCharacterStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBinaryStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateAsciiStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNCharacterStream()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.columnByName(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.columnByName(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.columnByName(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.columnByName(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.columnByName(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.columnByName(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.columnByName(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.columnByName(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.columnByName(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.columnByName(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.columnByName(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.columnByName(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.columnByName(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.columnByName(string), timestamp);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.columnByName(string), inputStream, n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.columnByName(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.columnByName(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.columnByName(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.columnByName(string), object, n);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.columnByName(string), array);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.columnByName(string), blob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.columnByName(string), clob);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.columnByName(string), ref);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateClob(this.columnByName(string), (Clob)nClob);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.columnByName(string), string2);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.columnByName(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.columnByName(string), reader);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.columnByName(string), inputStream);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.columnByName(string), reader);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.columnByName(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.columnByName(string), inputStream);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.columnByName(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.columnByName(string), reader, l);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.columnByName(string), reader, l);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.columnByName(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.columnByName(string), reader, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.columnByName(string), inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.columnByName(string), inputStream, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.columnByName(string), reader, l);
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".findColumn('" + string + "')");
        }
        try {
            n = this.columnByName(string);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".findColumn: not found");
            }
            throw sQLException;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".findColumn: " + n);
        }
        return n;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".wasNull(): " + this.isNull);
        }
        return this.isNull;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        SqlData sqlData;
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean( " + n + " )");
        }
        boolean bl2 = bl = (sqlData = this.columnDataValue(n)).isNull() ? false : sqlData.getBoolean();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean: " + bl);
        }
        return bl;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        SqlData sqlData;
        byte by;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte( " + n + " )");
        }
        byte by2 = by = (sqlData = this.columnDataValue(n)).isNull() ? (byte)0 : sqlData.getByte();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte: " + by);
        }
        return by;
    }

    @Override
    public short getShort(int n) throws SQLException {
        SqlData sqlData;
        short s;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort( " + n + " )");
        }
        short s2 = s = (sqlData = this.columnDataValue(n)).isNull() ? (short)0 : sqlData.getShort();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort: " + s);
        }
        return s;
    }

    @Override
    public int getInt(int n) throws SQLException {
        SqlData sqlData;
        int n2;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt( " + n + " )");
        }
        int n3 = n2 = (sqlData = this.columnDataValue(n)).isNull() ? 0 : sqlData.getInt();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt: " + n2);
        }
        return n2;
    }

    @Override
    public long getLong(int n) throws SQLException {
        SqlData sqlData;
        long l;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong( " + n + " )");
        }
        long l2 = l = (sqlData = this.columnDataValue(n)).isNull() ? 0L : sqlData.getLong();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong: " + l);
        }
        return l;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        SqlData sqlData;
        float f;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat( " + n + " )");
        }
        float f2 = f = (sqlData = this.columnDataValue(n)).isNull() ? 0.0f : sqlData.getFloat();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat: " + f);
        }
        return f;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        SqlData sqlData;
        double d;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble( " + n + " )");
        }
        double d2 = d = (sqlData = this.columnDataValue(n)).isNull() ? 0.0 : sqlData.getDouble();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble: " + d);
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        SqlData sqlData;
        BigDecimal bigDecimal;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal( " + n + " )");
        }
        BigDecimal bigDecimal2 = bigDecimal = (sqlData = this.columnDataValue(n)).isNull() ? null : sqlData.getBigDecimal();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        SqlData sqlData;
        BigDecimal bigDecimal;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal( " + n + ", " + n2 + " )");
        }
        BigDecimal bigDecimal2 = bigDecimal = (sqlData = this.columnDataValue(n)).isNull() ? null : sqlData.getBigDecimal(n2);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    @Override
    public String getString(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString( " + n + " )");
        }
        String string = (sqlData = this.columnDataValue(n)).isNull() ? null : (this.rs_max_len > 0 ? sqlData.getString(this.rs_max_len) : sqlData.getString());
        if (sqlData instanceof IngresDate && ((IngresDate)sqlData).isInterval()) {
            this.warnings = null;
            this.setWarning(SqlWarn.get(ERR_GC401B_INVALID_DATE));
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString: " + string);
        }
        return string;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes( " + n + " )");
        }
        byte[] byArray = (sqlData = this.columnDataValue(n)).isNull() ? null : (this.rs_max_len > 0 ? sqlData.getBytes(this.rs_max_len) : sqlData.getBytes());
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes: " + (byArray == null ? "null" : "[" + byArray.length + "]"));
        }
        return byArray;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate( " + n + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
        SqlData sqlData = this.columnDataValue(n);
        Date date2 = date = sqlData.isNull() ? null : sqlData.getDate(timeZone);
        if (sqlData instanceof IngresDate && sqlData.isTruncated() && sqlData.getTruncSize() > 0) {
            this.warnings = null;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate: " + date);
        }
        return date;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime( " + n + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
        SqlData sqlData = this.columnDataValue(n);
        Time time2 = time = sqlData.isNull() ? null : sqlData.getTime(timeZone);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime: " + time);
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp( " + n + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
        SqlData sqlData = this.columnDataValue(n);
        Timestamp timestamp2 = timestamp = sqlData.isNull() ? null : sqlData.getTimestamp(timeZone);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp: " + timestamp);
        }
        return timestamp;
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBinaryStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            inputStream = sqlData.isNull() ? null : sqlData.getBinaryStream();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getBinaryStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBinaryStream: " + inputStream);
        }
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAsciiStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            inputStream = sqlData.isNull() ? null : sqlData.getAsciiStream();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getAsciiStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAsciiStream: " + inputStream);
        }
        return inputStream;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUnicodeStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            inputStream = sqlData.isNull() ? null : sqlData.getUnicodeStream();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getUnicodeStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUnicodeStream: " + inputStream);
        }
        return inputStream;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Reader reader;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            reader = sqlData.isNull() ? null : sqlData.getCharacterStream();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getCharacterStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream: " + reader);
        }
        return reader;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBlob( " + n + " )");
        }
        Blob blob = (sqlData = this.columnDataValue(n)).isNull() ? null : sqlData.getBlob();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBlob: " + blob);
        }
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClob( " + n + " )");
        }
        Clob clob = (sqlData = this.columnDataValue(n)).isNull() ? null : sqlData.getClob();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClob: " + clob);
        }
        return clob;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNClob( " + n + " )");
        }
        NClob nClob = (sqlData = this.columnDataValue(n)).isNull() ? null : sqlData.getNlob();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNClob: " + nClob);
        }
        return nClob;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject( " + n + " )");
        }
        Object object = (sqlData = this.columnDataValue(n)).isNull() ? null : (this.rs_max_len > 0 ? sqlData.getObject(this.rs_max_len) : sqlData.getObject());
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject: " + object);
        }
        return object;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getArray( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRef( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getURL( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSQLXML( " + string + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSQLXML( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRowId( " + string + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRowId( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWrapperFor(" + clazz + ")");
        }
        if (clazz != null) {
            return clazz.isInstance(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".unwrap(" + clazz + ")");
        }
        if (clazz != null) {
            if (!clazz.isInstance(this)) {
                throw SqlExFactory.get(ERR_GC4023_NO_OBJECT);
            }
            return clazz.cast(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.columnByName(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.columnByName(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.columnByName(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.columnByName(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.columnByName(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.columnByName(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.columnByName(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.columnByName(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.columnByName(string), n);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.columnByName(string));
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.columnByName(string));
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.columnByName(string), null);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.columnByName(string), calendar);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.columnByName(string), null);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.columnByName(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.columnByName(string), null);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.columnByName(string), calendar);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.columnByName(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.columnByName(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.columnByName(string));
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.columnByName(string));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.columnByName(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.columnByName(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.columnByName(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.columnByName(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.columnByName(string));
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.columnByName(string));
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.columnByName(string));
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.columnByName(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(this.columnByName(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.columnByName(string));
    }

    protected int columnMap(int n) throws SQLException {
        if (this.posStatus == 0) {
            throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
        }
        if (this.posStatus != 3 || (this.currentRow.status & 0x40) != 0) {
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        if (n < 1 || n > this.rsmd.count) {
            throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
        }
        if (--n >= this.currentRow.count) {
            this.flush(n);
        }
        return n;
    }

    protected SqlData getSqlData(int n) throws SQLException {
        return this.currentRow.columns[n];
    }

    private int columnByName(String string) throws SQLException {
        for (int i = 0; i < this.rsmd.count; ++i) {
            if (this.rsmd.desc[i].name == null || !this.rsmd.desc[i].name.equalsIgnoreCase(string)) continue;
            ++i;
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ": column '" + string + "' => " + i);
            }
            return i;
        }
        if (this.trace.enabled(5)) {
            this.trace.write(this.tr_id + ": column '" + string + "' not found!");
        }
        throw SqlExFactory.get(ERR_GC4012_INVALID_COLUMN_NAME);
    }

    private synchronized SqlData columnDataValue(int n) throws SQLException {
        this.warnings = null;
        SqlData sqlData = this.getSqlData(this.columnMap(n));
        this.isNull = sqlData.isNull();
        if (!this.isNull && sqlData.isTruncated()) {
            this.setWarning(new DataTruncation(n, false, true, sqlData.getDataSize(), sqlData.getTruncSize()));
        }
        return sqlData;
    }

    protected static class Row {
        public static final int FIRST = 1;
        public static final int LAST = 2;
        public static final int INSERTED = 16;
        public static final int UPDATED = 32;
        public static final int DELETED = 64;
        public int status = 0;
        public int id = 0;
        public int count = 0;
        public SqlData[] columns = null;

        protected Row() {
        }
    }
}

