/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.ui.config;

import com.dbeaver.db.oracle.ui.OraclePROUIMessages;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.utils.CommonUtils;

public class OracleTablePartitionConfigurator
implements DBEObjectConfigurator<OracleTablePartition> {
    public OracleTablePartition configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, @NotNull OracleTablePartition object, @NotNull Map<String, Object> options) {
        return (OracleTablePartition)UITask.run(() -> {
            PartitionEditPage editPage = new PartitionEditPage(object);
            if (!editPage.edit()) {
                return null;
            }
            object.setName(editPage.getPartitionName());
            object.setValuesForCreating(editPage.values);
            return object;
        });
    }

    class PartitionEditPage
    extends BaseObjectEditPage {
        OracleTablePartition partition;
        String name;
        String values;
        List valuesList;

        public PartitionEditPage(OracleTablePartition partition) {
            super(OraclePROUIMessages.partition_configurator_title);
            this.partition = partition;
        }

        protected Control createPageContents(Composite parent) {
            Composite propsGroup = new Composite(parent, 0);
            propsGroup.setLayout((Layout)new GridLayout(1, false));
            GridData gd = new GridData(768);
            propsGroup.setLayoutData((Object)gd);
            OracleTablePhysical partitionParent = this.partition.getParent();
            Group group = UIUtils.createControlGroup((Composite)propsGroup, (String)OraclePROUIMessages.partition_configurator_group_general, (int)2, (int)768, (int)0);
            UIUtils.createLabelText((Composite)group, (String)OraclePROUIMessages.partition_configurator_parent_table_label, (String)partitionParent.getFullyQualifiedName(DBPEvaluationContext.DDL)).setEditable(false);
            Text nameText = UIUtils.createLabelText((Composite)group, (String)OraclePROUIMessages.partition_configurator_partition_name_text, null);
            nameText.addModifyListener(e -> {
                String string = this.name = nameText.getText();
            });
            nameText.setFocus();
            Group repoGroup = UIUtils.createControlGroup((Composite)propsGroup, (String)OraclePROUIMessages.partition_configurator_group_values, (int)2, (int)768, (int)0);
            this.valuesList = new List((Composite)repoGroup, 2820);
            this.valuesList.setLayoutData((Object)new GridData(1808));
            ToolBar toolbar = new ToolBar((Composite)repoGroup, 512);
            toolbar.setLayoutData((Object)new GridData(2));
            UIUtils.createToolItem((ToolBar)toolbar, (String)OraclePROUIMessages.partition_configurator_list_add_value_text, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String value = EnterNameDialog.chooseName((Shell)PartitionEditPage.this.getShell(), (String)OraclePROUIMessages.partition_configurator_dialog_add_values_title, (String)"");
                    if (value != null) {
                        PartitionEditPage.this.valuesList.add(value);
                        PartitionEditPage.this.updatePageState();
                    }
                }
            });
            final ToolItem removeButton = UIUtils.createToolItem((ToolBar)toolbar, (String)OraclePROUIMessages.partition_configurator_remove_value_button, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = PartitionEditPage.this.valuesList.getSelectionIndex();
                    PartitionEditPage.this.valuesList.remove(index);
                    PartitionEditPage.this.valuesList.select(CommonUtils.clamp((int)index, (int)0, (int)(PartitionEditPage.this.valuesList.getItemCount() - 1)));
                    PartitionEditPage.this.valuesList.notifyListeners(13, new Event());
                    PartitionEditPage.this.updatePageState();
                }
            });
            removeButton.setEnabled(false);
            this.valuesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (PartitionEditPage.this.valuesList.getSelectionIndex() >= 0) {
                        removeButton.setEnabled(PartitionEditPage.this.valuesList.getItemCount() > 0);
                    } else {
                        removeButton.setEnabled(false);
                    }
                }
            });
            Object tooltip = partitionParent.isPersisted() ? OraclePROUIMessages.partition_configurator_values_tip : OraclePROUIMessages.partition_configurator_values_tip + "\n" + OraclePROUIMessages.partition_configurator_values_tip_extra;
            Control tip = UIUtils.createInfoLabel((Composite)repoGroup, (String)tooltip);
            tip.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
            return propsGroup;
        }

        String getPartitionName() {
            return DBObjectNameCaseTransformer.transformName((DBPDataSource)this.partition.getDataSource(), (String)this.name);
        }

        public DBSObject getObject() {
            return this.partition;
        }

        public boolean isPageComplete() {
            return CommonUtils.isNotEmpty((String)this.name) && this.valuesList.getItemCount() > 0;
        }

        public void performFinish() throws DBException {
            StringJoiner sources = new StringJoiner(", ");
            String[] stringArray = this.valuesList.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                sources.add(item);
                ++n2;
            }
            this.values = sources.toString();
            super.performFinish();
        }
    }
}

