/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.aggr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.search.aggr.Limit;
import redis.clients.jedis.search.aggr.Reducer;

public class Group {
    private final List<Reducer> reducers = new ArrayList<Reducer>();
    private final List<String> fields = new ArrayList<String>();
    private Limit limit = new Limit(0, 0);

    public Group(String ... fields) {
        this.fields.addAll(Arrays.asList(fields));
    }

    public Group reduce(Reducer r) {
        this.reducers.add(r);
        return this;
    }

    @Deprecated
    public Group limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public void addArgs(List<String> args) {
        args.add(Integer.toString(this.fields.size()));
        args.addAll(this.fields);
        for (Reducer r : this.reducers) {
            args.add("REDUCE");
            args.add(r.getName());
            r.addArgs(args);
            String alias = r.getAlias();
            if (alias == null || alias.isEmpty()) continue;
            args.add("AS");
            args.add(alias);
        }
        args.addAll(this.limit.getArgs());
    }

    @Deprecated
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        this.addArgs(args);
        return args;
    }
}

