/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.utils.Pair;

public abstract class BaseSystemScheduler
implements DBTScheduler {
    protected static String getRunTaskParameter(DBTTask task) {
        return BaseSystemScheduler.encodeTaskReference(task.getProject().getName(), task.getName());
    }

    protected static String encodeTaskReference(@NotNull String projectName, @NotNull String taskName) {
        return "@" + projectName + ":" + taskName;
    }

    protected static Pair<String, String> decodeTaskReference(@NotNull String taskRef) {
        if (!taskRef.startsWith("@") || !taskRef.contains(":")) {
            throw new IllegalArgumentException("Invalid task reference: " + taskRef);
        }
        String[] parts = taskRef.substring(1).split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Malformed task reference: " + taskRef);
        }
        return Pair.of((Object)parts[0], (Object)parts[1]);
    }

    @NotNull
    protected static String getDataParameter(@NotNull DBTTask task) {
        return task.getProject().getWorkspace().getAbsolutePath().toString();
    }
}

