/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.rds;

import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.aws.AWSDatabaseEngine;
import com.dbeaver.cloud.aws.rds.AWSCloudRdsBaseInstance;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.Endpoint;

public class AWSCloudRdsInstance
extends AWSCloudRdsBaseInstance {
    public static final AWSDatabaseEngine[] SUPPORTED_RDS_ENGINES = new AWSDatabaseEngine[]{AWSDatabaseEngine.AURORA, AWSDatabaseEngine.AURORA_MYSQL, AWSDatabaseEngine.AURORA_POSTGRESQL, AWSDatabaseEngine.MARIADB, AWSDatabaseEngine.MYSQL, AWSDatabaseEngine.POSTGRES, AWSDatabaseEngine.ORACLE_SE, AWSDatabaseEngine.ORACLE_SE1, AWSDatabaseEngine.ORACLE_SE2, AWSDatabaseEngine.ORACLE_EE, AWSDatabaseEngine.SQLSERVER_SE, AWSDatabaseEngine.SQLSERVER_EE, AWSDatabaseEngine.SQLSERVER_EX};
    private final DBInstance dbInstance;

    public AWSCloudRdsInstance(AWSCloudSession session, AWSCloudZone zone, DBInstance dbInstance) {
        super(session, zone);
        this.dbInstance = dbInstance;
    }

    @NotNull
    public String getNodeId() {
        return this.dbInstance.dbInstanceIdentifier();
    }

    @NotNull
    public String getNodeName() {
        return this.dbInstance.dbInstanceIdentifier();
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public String getNodeDisplayName() {
        if (CommonUtils.isEmpty((String)this.dbInstance.dbClusterIdentifier())) {
            return this.dbInstance.dbInstanceIdentifier();
        }
        return this.dbInstance.dbInstanceIdentifier() + "@" + this.dbInstance.dbClusterIdentifier();
    }

    @Nullable
    public String getInstanceEndpoint() {
        Endpoint endpoint = this.dbInstance.endpoint();
        return endpoint == null ? null : endpoint.address();
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setDatabaseName(this.dbInstance.dbName());
        Endpoint endpoint = this.dbInstance.endpoint();
        if (endpoint != null) {
            configuration.setHostName(endpoint.address());
            configuration.setHostPort(CommonUtils.toString((Object)endpoint.port()));
        }
        configuration.setUserName(this.getInstanceUserName());
        AWSDatabaseEngine instanceFamily = AWSCloudRdsInstance.getInstanceFamilyByEngine(this.dbInstance.engine());
        if (this.dbInstance.iamDatabaseAuthenticationEnabled().booleanValue()) {
            configuration.setAuthModelId("iam");
        } else {
            configuration.setAuthModelId("native");
        }
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
        if (instanceFamily != null) {
            this.setDefaultDataSourceConfiguration(this.dbInstance, instanceFamily, configuration);
        }
    }

    @Override
    protected AWSCloudService getCloudService() {
        AWSDatabaseEngine instanceEngineFamily = AWSCloudRdsInstance.getInstanceFamilyByEngine(this.dbInstance.engine());
        if (instanceEngineFamily == null) {
            return AWSCloudService.UNKNOWN;
        }
        switch (instanceEngineFamily) {
            case AURORA_POSTGRESQL: 
            case POSTGRES: {
                return AWSCloudService.RDS_POSTGRESQL;
            }
            case AURORA: 
            case AURORA_MYSQL: 
            case MYSQL: {
                return AWSCloudService.RDS_MYSQL;
            }
            case MARIADB: {
                return AWSCloudService.RDS_MARIADB;
            }
            case ORACLE_SE: 
            case ORACLE_SE1: 
            case ORACLE_SE2: 
            case ORACLE_EE: {
                return AWSCloudService.RDS_ORACLE;
            }
            case SQLSERVER_SE: 
            case SQLSERVER_EE: 
            case SQLSERVER_EX: {
                return AWSCloudService.RDS_SQLSERVER;
            }
            case DOCDB: {
                return AWSCloudService.DOCUMENTDB;
            }
        }
        return AWSCloudService.UNKNOWN;
    }

    @Nullable
    public static AWSDatabaseEngine getInstanceFamilyByEngine(String engineId) {
        AWSDatabaseEngine instanceEngineFamily = null;
        AWSDatabaseEngine[] aWSDatabaseEngineArray = AWSDatabaseEngine.values();
        int n = aWSDatabaseEngineArray.length;
        int n2 = 0;
        while (n2 < n) {
            AWSDatabaseEngine engine = aWSDatabaseEngineArray[n2];
            if (engine.getEngineId().equals(engineId)) {
                instanceEngineFamily = engine;
                break;
            }
            ++n2;
        }
        return instanceEngineFamily;
    }

    @Override
    @Nullable
    protected String getInstanceUserName() {
        String userName = super.getInstanceUserName();
        return userName != null ? userName : this.dbInstance.masterUsername();
    }

    @Override
    protected String getInstanceARN() {
        return this.dbInstance.dbInstanceArn();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix() + "database:id=" + this.dbInstance.dbInstanceIdentifier() + ";is-cluster=" + !CommonUtils.isEmpty((String)this.dbInstance.dbClusterIdentifier());
    }

    @Property(viewable=true, order=40)
    @NotNull
    public String getRdsInstanceIdentifier() {
        return this.dbInstance.dbInstanceIdentifier();
    }

    @Property(viewable=true, order=50)
    @NotNull
    public String getRdsEngine() {
        return this.dbInstance.engine();
    }

    @Property(viewable=true, order=51)
    @NotNull
    public String getRdsEngineVersion() {
        return this.dbInstance.engineVersion();
    }

    @Property(viewable=true, order=53)
    @NotNull
    public String getRdsInstanceStatus() {
        return this.dbInstance.dbInstanceStatus();
    }

    @Property(viewable=true, order=54)
    @NotNull
    public String getRdsInstanceClass() {
        return this.dbInstance.dbInstanceClass();
    }
}

