/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.documentdb;

import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.aws.AWSDatabaseEngine;
import com.dbeaver.cloud.aws.rds.AWSCloudRdsBaseInstance;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.docdb.model.DBCluster;

public class AWSCloudDocumentDBCluster
extends AWSCloudRdsBaseInstance {
    private final DBCluster cluster;

    public AWSCloudDocumentDBCluster(AWSCloudSession session, AWSCloudZone zone, DBCluster cluster) {
        super(session, zone);
        this.cluster = cluster;
    }

    @NotNull
    public String getNodeId() {
        return this.cluster.dbClusterArn();
    }

    @NotNull
    public String getNodeName() {
        return this.cluster.dbClusterIdentifier();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.cluster.endpoint();
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setDatabaseName("local");
        configuration.setHostName(this.cluster.endpoint());
        configuration.setHostPort(CommonUtils.toString((Object)this.cluster.port()));
        this.setDefaultDataSourceConfiguration(null, AWSDatabaseEngine.DOCDB, configuration);
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.DOCUMENTDB;
    }

    @Override
    @Nullable
    protected String getInstanceUserName() {
        String userName = super.getInstanceUserName();
        return userName != null ? userName : this.cluster.masterUsername();
    }

    @Override
    protected String getInstanceARN() {
        return this.cluster.dbClusterArn();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix() + "cluster-details/" + this.cluster.dbClusterIdentifier();
    }
}

