/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.auth;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.impl.AbstractCloudSessionProvider;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class AwsLocalSessionProvider
extends AbstractCloudSessionProvider<AWSCloud, AuthModelAWSCredentials> {
    @Nullable
    public AWSCloudSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext context, @NotNull SMSession mainSession, @NotNull AWSCloud cloud) throws DBException {
        String arn = null;
        AWSCloudConfiguration configuration = (AWSCloudConfiguration)cloud.getCloudConfiguration();
        ArrayList<AWSCloudZone> useZones = new ArrayList<AWSCloudZone>();
        String[] stringArray = configuration.getDefaultRegions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String regionId = stringArray[n2];
            useZones.add(AWSCloudZone.valueOf(Region.of((String)regionId)));
            ++n2;
        }
        AuthModelAWSCredentials iamCredentials = configuration.getDefaultCredentials();
        if (!this.updateCredentialsFromSession(mainSession, iamCredentials)) {
            iamCredentials = (AuthModelAWSCredentials)this.updateCredentialsFromService((CPCloud)cloud, (DBAAuthCredentials)iamCredentials);
        }
        return new AWSCloudSession(context, mainSession, cloud, arn, iamCredentials, useZones.toArray(new AWSCloudZone[0]));
    }

    public boolean updateCredentialsFromSession(@NotNull SMSession mainSession, @NotNull AuthModelAWSCredentials credentials) {
        Map objectMap;
        if (DBWorkbench.isDistributed() && CommonUtils.isEmpty((String)credentials.getAwsAccessKey()) && CommonUtils.isEmpty((String)credentials.getAwsSecretKey()) && !CommonUtils.isEmpty((Map)(objectMap = SMAuthUtils.getCredentialsFromSession((SMSession)mainSession, (String)"aws")))) {
            AWSIAMUtils.updateCredentialsFromSessionData((Map)objectMap, (AuthModelAWSCredentials)credentials);
            return true;
        }
        return false;
    }
}

