/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import software.amazon.awssdk.regions.Region;

public class AWSCloudUtils {
    private static final Log log = Log.getLog(AWSCloudUtils.class);
    private static final String SR_NORTH_AMERICA = "North America";
    private static final String SR_SOUTH_AMERICA = "South America";
    private static final String SR_EUROPE = "Europe";
    private static final String SR_ASIA = "Asia";
    private static final String SR_AFRICA = "Africa";
    private static final String GOVCLOUD = "GovCloud";

    public static List<AWSCloud> getAllClouds() throws DBException {
        return AWSCloudUtils.getAwsCloudProvider().getInstance().getAvailableClouds();
    }

    public static CloudProviderDescriptor getAwsCloudProvider() {
        return CloudProviderRegistry.getInstance().getCloudProvider("aws");
    }

    public static List<Region> getAllRegions(AWSCloudConfiguration awsConfig) {
        ArrayList<Region> allRegions = new ArrayList<Region>();
        for (Region region : Region.regions()) {
            if (region.isGlobalRegion() || region.id().contains("-iso") && (awsConfig == null || !awsConfig.isIsoRegionsEnabled()) || region.id().contains("-gov") && awsConfig != null && !awsConfig.isGovRegionsEnabled()) continue;
            allRegions.add(region);
        }
        allRegions.sort((o1, o2) -> {
            if (o1.id().contains("-gov") && !o2.id().contains("-gov")) {
                return 1;
            }
            if (o2.id().contains("-gov") && !o1.id().contains("-gov")) {
                return -1;
            }
            if (o1.id().startsWith("us-") && !o2.id().startsWith("us-")) {
                return -1;
            }
            if (o2.id().startsWith("us-") && !o1.id().startsWith("us-")) {
                return 1;
            }
            return o1.id().compareTo(o2.id());
        });
        return allRegions;
    }

    public static String getSuperRegion(Region region) {
        String srId;
        int divPos = region.id().indexOf(45);
        if (region.id().contains("-gov")) {
            return GOVCLOUD;
        }
        String string = srId = divPos < 0 ? null : region.id().substring(0, divPos);
        if (srId == null) {
            return null;
        }
        switch (srId) {
            case "ca": 
            case "us": {
                return SR_NORTH_AMERICA;
            }
            case "sa": {
                return SR_SOUTH_AMERICA;
            }
            case "eu": {
                return SR_EUROPE;
            }
            case "ap": 
            case "cn": 
            case "me": {
                return SR_ASIA;
            }
            case "af": {
                return SR_AFRICA;
            }
        }
        return srId;
    }
}

