/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AWSCloudSession
implements CPCloudSession<AWSCloudZone>,
DBACredentialsProvider {
    private final SMSessionContext context;
    private final SMSession parentSession;
    private final AWSCloud cloud;
    private final String arn;
    private final AuthModelAWSCredentials iamCredentials;
    private AWSCloudZone[] useZones;

    public AWSCloudSession(@NotNull SMSessionContext context, @NotNull SMSession parentSession, @NotNull AWSCloud cloud, String arn, @NotNull AuthModelAWSCredentials iamCredentials, @NotNull AWSCloudZone[] useZones) {
        this.context = context;
        this.parentSession = parentSession;
        this.cloud = cloud;
        this.arn = arn;
        this.iamCredentials = iamCredentials;
        this.useZones = useZones;
    }

    @NotNull
    public SMAuthSpace getSessionSpace() {
        return this.cloud;
    }

    @NotNull
    public SMSessionContext getSessionContext() {
        return this.context;
    }

    @Nullable
    public SMSessionPrincipal getSessionPrincipal() {
        return this.parentSession.getSessionPrincipal();
    }

    @NotNull
    public String getSessionId() {
        return this.parentSession.getSessionId();
    }

    @NotNull
    public LocalDateTime getSessionStart() {
        return this.parentSession.getSessionStart();
    }

    @NotNull
    public AWSCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public AWSCloudZone[] getDefaultZones() {
        return this.useZones;
    }

    public void setDefaultZones(@NotNull AWSCloudZone[] zones) {
        this.useZones = zones;
    }

    public String[] getDefaultZoneIds() {
        return (String[])Arrays.stream(this.useZones).map(AWSCloudZone::getZoneId).toArray(String[]::new);
    }

    public String getArn() {
        return this.arn;
    }

    public String getUserArn() {
        return this.arn;
    }

    public AuthModelAWSCredentials getIamCredentials() {
        return this.iamCredentials;
    }

    public void closeSession() {
        this.context.removeSession((SMSession)this);
    }

    public boolean provideAuthParameters(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        this.iamCredentials.getAuthCredentialsProvider(monitor, configuration, ((AWSCloudConfiguration)this.cloud.getCloudConfiguration()).getStsRegion().id());
        configuration.setRuntimeAttribute("iam.credentials", (Object)this.iamCredentials);
        DBAAuthModel authModel = configuration.getAuthModel();
        return authModel instanceof AuthModelAWSAbstract && !CommonUtils.equalObjects((Object)"iam", (Object)configuration.getAuthModelId());
    }

    public void close() {
        this.closeSession();
    }

    @NotNull
    public String getAuthContextType() {
        return "aws";
    }
}

